/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.coords;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import net.blockomorph.network.ClientBoundBlockPosBoundPacket;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.PlayerMorphedSection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class BlockPosBounds {
    private static File FILE;
    public static final int MAX_PLAYER_CHUNKS = 1875000;
    private static final RandomSource random;
    public static final HashMap<PlayerMorphedSection, Player> CACHE;
    public static final HashMap<PlayerMorphedSection, Player> CLIENT_CACHE;
    private static final HashMap<UUID, PlayerMorphedSection> BOUNDS;
    private static final HashMap<UUID, PlayerMorphedSection> CLIENT_BOUNDS;

    public static void boundPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            UUID uuid = player.m_20148_();
            if (!BOUNDS.containsKey(uuid)) {
                PlayerMorphedSection pos = BlockPosBounds.getChunkPos();
                BOUNDS.put(uuid, pos);
                BlockPosBounds.save();
            }
            CACHE.put(BOUNDS.get(uuid), player);
        }
    }

    private static PlayerMorphedSection getChunkPos() {
        int z;
        int x;
        PlayerMorphedSection pos;
        while (BOUNDS.containsValue(pos = new PlayerMorphedSection(x = random.m_188503_(1875000), z = random.m_188503_(1875000)))) {
        }
        return pos;
    }

    @Nullable
    public static PlayerMorphedSection getChunkPosForPlayer(Player player) {
        if (player.m_9236_().f_46443_) {
            return CLIENT_BOUNDS.get(player.m_20148_());
        }
        return BOUNDS.get(player.m_20148_());
    }

    public static PlayerMorphedSection getPlayerSectionPos(BlockPos bounded) {
        int blockZ = bounded.m_123343_();
        int blockX = bounded.m_123341_();
        int shiftedZ = blockZ;
        int shiftedX = blockX - 60000000;
        int sectorZ = shiftedZ / 32;
        int sectorX = shiftedX / 32;
        return new PlayerMorphedSection(sectorX, sectorZ);
    }

    @Nullable
    public static Player getPlayerByChunkPos(PlayerMorphedSection pos, @Nullable Boolean client) {
        HashMap<PlayerMorphedSection, Player> cash = client != null ? (client != false ? CLIENT_CACHE : CACHE) : (Config.getServer() == null ? CLIENT_CACHE : CACHE);
        Player pl = cash.get(pos);
        if (pl == null) {
            return null;
        }
        if (pl.m_213877_()) {
            cash.remove(pos);
            pl = null;
        }
        return pl;
    }

    private static void initFile() {
        if (Config.getServer() != null) {
            FILE = new File(Config.getServer().m_129843_(new LevelResource("data")).toFile(), "blockomorph.dat");
        }
    }

    public static void load() {
        CompoundTag tg;
        BlockPosBounds.initFile();
        if (FILE == null || !FILE.exists()) {
            return;
        }
        try {
            tg = NbtIo.m_128937_((File)FILE);
        }
        catch (IOException ex) {
            MorphUtils.LOGGER.error("Unable to read PLAYER-BLOCKPOS mappings.", (Throwable)ex);
            return;
        }
        for (String key : tg.m_128431_()) {
            BOUNDS.put(UUID.fromString(key), new PlayerMorphedSection(tg.m_128454_(key)));
        }
    }

    private static void save() {
        if (FILE == null) {
            return;
        }
        CompoundTag tg = new CompoundTag();
        BOUNDS.forEach((uuid, chunkPos) -> tg.m_128356_(uuid.toString(), chunkPos.toLong()));
        try {
            NbtIo.m_128944_((CompoundTag)tg, (File)FILE);
        }
        catch (IOException ex) {
            MorphUtils.LOGGER.error("Unable to save PLAYER-BLOCKPOS mappings.", (Throwable)ex);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        MinecraftServer sv = event.getLevel().m_7654_();
        if (sv != null && !sv.m_6982_()) {
            BOUNDS.clear();
            CACHE.clear();
            Config.setServer(null);
        }
        CLIENT_BOUNDS.clear();
        CLIENT_CACHE.clear();
    }

    public static void onJoin(Player entity) {
        BlockPosBounds.boundPlayer(entity);
        PlayerMorphedSection pos = BlockPosBounds.getChunkPosForPlayer(entity);
        if (pos != null) {
            MorphUtils.sendPlayer(new ClientBoundBlockPosBoundPacket(pos, entity, false), (ServerPlayer)entity);
        }
    }

    public static void handleBlockPosBound(ClientBoundBlockPosBoundPacket packet) {
        if (packet.delete) {
            Player old = CLIENT_CACHE.remove(packet.pos);
            if (old != null) {
                CLIENT_BOUNDS.remove(old.m_20148_());
            }
        } else {
            Player pl = packet.getPlayer();
            if (pl != null) {
                CLIENT_BOUNDS.put(pl.m_20148_(), packet.pos);
                CLIENT_CACHE.put(packet.pos, pl);
            }
        }
    }

    static {
        random = RandomSource.m_216327_();
        CACHE = new HashMap();
        CLIENT_CACHE = new HashMap();
        BOUNDS = new HashMap();
        CLIENT_BOUNDS = new HashMap();
    }
}

