/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.coords;

import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class DummyLevelChunk
extends EmptyLevelChunk {
    private final Level level;

    public DummyLevelChunk(Level lv, ChunkPos boundedSection) {
        super(lv, boundedSection, (Holder)lv.m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_));
        this.level = lv;
    }

    @Nullable
    public BlockState m_6978_(BlockPos pos, BlockState state, boolean update) {
        CallbackInfoReturnable cir = new CallbackInfoReturnable("", true, (Object)Blocks.f_50016_.m_49966_());
        DummyLevelChunk.setBlockState(this.level, pos, state, update, (CallbackInfoReturnable<BlockState>)cir);
        return (BlockState)cir.getReturnValue();
    }

    public BlockState m_8055_(BlockPos pos) {
        CallbackInfoReturnable cir = new CallbackInfoReturnable("", true, (Object)Blocks.f_50016_.m_49966_());
        DummyLevelChunk.getBlockState(this.level, pos, (CallbackInfoReturnable<BlockState>)cir);
        return (BlockState)cir.getReturnValue();
    }

    @Nullable
    public BlockEntity m_5685_(BlockPos pos, LevelChunk.EntityCreationType p_62610_) {
        CallbackInfoReturnable cir = new CallbackInfoReturnable("", true, null);
        DummyLevelChunk.getBlockEntity(this.level, pos, (CallbackInfoReturnable<BlockEntity>)cir);
        return (BlockEntity)cir.getReturnValue();
    }

    public FluidState m_62814_(int x, int y, int z) {
        CallbackInfoReturnable cir = new CallbackInfoReturnable("", true, (Object)Fluids.f_76191_.m_76145_());
        DummyLevelChunk.getFluidState(this.level, new BlockPos(x, y, z), (CallbackInfoReturnable<FluidState>)cir);
        return (FluidState)cir.getReturnValue();
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_62814_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public void m_8114_(BlockPos pos) {
        DummyLevelChunk.removeBlockEntity(this.level, pos, new CallbackInfo("", true));
    }

    public FullChunkStatus m_287138_() {
        return FullChunkStatus.BLOCK_TICKING;
    }

    public static void setBlockState(Level level, BlockPos pos, BlockState state, boolean update, CallbackInfoReturnable<BlockState> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            cir.setReturnValue((Object)pl.getBlockState((InPlayerBlockPos)realPos));
            if (!pl.setBlockState((InPlayerBlockPos)realPos, state, update)) {
                cir.setReturnValue(null);
            }
        }, null, (LevelReader)level);
    }

    public static void removeBlockEntity(Level level, BlockPos pos, CallbackInfo ci) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            ci.cancel();
            BlockInPlayer2 block = pl.getBlocksData2().get(realPos);
            if (block != null) {
                block.clearBlockEntity();
            }
        }, () -> ((CallbackInfo)ci).cancel(), (LevelReader)level);
    }

    public static void getBlockState(Level level, BlockPos pos, CallbackInfoReturnable<BlockState> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            ClientLevelAccessor acc;
            BlockState state = pl.getBlockState((InPlayerBlockPos)realPos);
            if (state == null) {
                cir.setReturnValue((Object)Blocks.f_50016_.m_49966_());
            } else if (level instanceof ClientLevelAccessor && (acc = (ClientLevelAccessor)level).isExternalMorphedBlockGetterLocked()) {
                cir.setReturnValue((Object)state);
            } else if (state.m_60795_() && !realPos.equals(InPlayerBlockPos.ZERO)) {
                Vec3 vec = MorphUtils.getCetneredRealBlockPos(pl, realPos);
                cir.setReturnValue((Object)level.m_8055_(BlockPos.m_274446_((Position)vec)));
            } else {
                cir.setReturnValue((Object)state);
            }
        }, null, (LevelReader)level);
    }

    public static void getBlockEntity(Level level, BlockPos pos, CallbackInfoReturnable<BlockEntity> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> cir.setReturnValue((Object)pl.getBlockEntity((InPlayerBlockPos)realPos)), null, (LevelReader)level);
    }

    public static void getFluidState(Level level, BlockPos pos, CallbackInfoReturnable<FluidState> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            BlockState state = pl.getBlockState((InPlayerBlockPos)realPos);
            if (state == null || state.m_60795_() && !realPos.equals(InPlayerBlockPos.ZERO)) {
                Vec3 vec = MorphUtils.getCetneredRealBlockPos(pl, realPos);
                cir.setReturnValue((Object)level.m_6425_(BlockPos.m_274446_((Position)vec)));
            } else {
                cir.setReturnValue((Object)state.m_60819_());
            }
        }, null, (LevelReader)level);
    }
}

