/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.coords;

import java.util.Objects;
import javax.annotation.Nullable;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;

public class PlayerMorphedSection {
    public static final int MAX_SIZE = 31;
    public static final int FOR_TWO_CHUNKS = 32;
    public final int x;
    public final int z;

    public PlayerMorphedSection(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public PlayerMorphedSection(long encoded) {
        this.x = (int)encoded;
        this.z = (int)(encoded >> 32);
    }

    @Nullable
    public static Player getPlayerByChunkPos(ChunkPos real, @Nullable Boolean client) {
        if (!InPlayerBlockPos.isMorphPlayerChunk(real)) {
            return null;
        }
        BlockPos bounded = new BlockPos((Vec3i)real.m_151384_(7, 0, 7));
        PlayerMorphedSection section = BlockPosBounds.getPlayerSectionPos(bounded);
        return BlockPosBounds.getPlayerByChunkPos(section, client);
    }

    public long toLong() {
        return ChunkPos.m_45589_((int)this.x, (int)this.z);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PlayerMorphedSection) {
            PlayerMorphedSection section = (PlayerMorphedSection)obj;
            return section.x == this.x && section.z == this.z;
        }
        return false;
    }

    public String toString() {
        return "PlayerMorphedSection[" + this.x + ", " + this.z + "]";
    }
}

