/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.dataSyncher;

import java.util.Objects;
import net.blockomorph.utils.dataSyncher.SyncedEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public abstract class AutoSyncedEntityData<DATA> {
    protected DATA data;
    protected final ResourceLocation id;
    protected boolean isDirty;
    private final SyncedEntity entity;
    private final Runnable onSynced;

    protected AutoSyncedEntityData(Entity entity, ResourceLocation id, DATA defaultValue, Runnable onSynced) {
        if (!(entity instanceof SyncedEntity)) {
            throw new IllegalStateException("Cannot register entity syncer from blockomorph! Most likely mixin not applied or missing! Class: " + entity.getClass() + " Id: " + id);
        }
        SyncedEntity syncedEntity = (SyncedEntity)entity;
        syncedEntity.registerDataSyncer(this);
        this.id = id;
        this.entity = syncedEntity;
        this.data = Objects.requireNonNull(defaultValue);
        this.onSynced = onSynced;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public final void writeInNetwork(FriendlyByteBuf buffer) {
        this.writeInBuffer(buffer);
        this.isDirty = false;
    }

    public final void readFromNetwork(FriendlyByteBuf buffer) {
        this.readFromBuffer(buffer);
    }

    protected abstract void readFromBuffer(FriendlyByteBuf var1);

    protected abstract void writeInBuffer(FriendlyByteBuf var1);

    public final void onReceived() {
        if (this.onSynced != null) {
            this.onSynced.run();
        }
    }

    public void set(DATA data) {
        if (!this.data.equals(data)) {
            this.data = data;
            this.isDirty = true;
            this.entity.setDirty();
            this.onReceived();
        }
    }

    public DATA get() {
        return this.data;
    }
}

