/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.hit;

import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MorphedPlayerHitResult
extends BlockHitResult {
    private final PlayerAccessor player;
    private final InPlayerBlockPos offset;
    private final Vec3 realLocation;

    private MorphedPlayerHitResult(BlockHitResult hit, MorphedPlayerHitResult self) {
        super(hit.m_82450_(), hit.m_82434_(), hit.m_82425_(), hit.m_82436_());
        this.player = self.player;
        this.offset = self.offset;
        this.realLocation = self.realLocation;
    }

    private MorphedPlayerHitResult(PlayerAccessor player, InPlayerBlockPos offset, BlockPos offsetIn, Vec3 inBlockOffset, Direction direction, boolean inside, Vec3 realLoc) {
        super(inBlockOffset.m_82520_((double)offsetIn.m_123341_(), (double)offsetIn.m_123342_(), (double)offsetIn.m_123343_()), direction, offsetIn, inside);
        this.offset = offset;
        this.player = player;
        this.realLocation = realLoc;
    }

    public MorphedPlayerHitResult withDirection(Direction direction) {
        return new MorphedPlayerHitResult(super.m_82432_(direction), this);
    }

    public MorphedPlayerHitResult withPosition(BlockPos blockPos) {
        return new MorphedPlayerHitResult(super.m_82430_(blockPos), this);
    }

    @Nullable
    protected static MorphedPlayerHitResult of(PlayerAccessor player, InPlayerBlockPos offset, Direction direction, boolean inside, Vec3 inBlockOffset, Vec3 realLoc) {
        BlockPos offsetIn = offset.boundedBlockPos(player.player());
        if (offsetIn == null) {
            return null;
        }
        return new MorphedPlayerHitResult(player, offset, offsetIn, inBlockOffset, direction, inside, realLoc);
    }

    public HitResult.Type m_6662_() {
        return HitResult.Type.BLOCK;
    }

    public PlayerAccessor getPlayer() {
        return this.player;
    }

    public InPlayerBlockPos getOffset() {
        return this.offset;
    }

    public Vec3 getRealLocation() {
        return this.realLocation;
    }
}

