/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.hit;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.ClipContextAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.util.TriConsumer;

public class PlayerHitResult {
    public static final Predicate<Entity> NOT_MORPHED_PLAYER = entity -> {
        PlayerAccessor pl;
        return !(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive();
    };
    private static final AABB CUBE = Shapes.m_83144_().m_83215_();

    @Nullable
    public static MorphedPlayerHitResult calculateMorphedPlayerHitResult(Level lv, @Nullable Entity looker, Vec3 eyePosition, Vec3 reachVector, ClipContext.Block mode, ClipContext.Fluid fluidMode) {
        AABB areaBetweenAndReachEnd = new AABB(eyePosition, reachVector);
        List entities = lv.m_45933_(looker, areaBetweenAndReachEnd);
        AtomicReference result = new AtomicReference();
        AtomicReference<Double> distanceToPartOfBlock = new AtomicReference<Double>((Double)Double.MAX_VALUE);
        for (Entity entity : entities) {
            PlayerAccessor mob;
            if (!(entity instanceof PlayerAccessor) || !(mob = (PlayerAccessor)entity).isFullActive()) continue;
            mob.getBlocksData2InArea(areaBetweenAndReachEnd, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(offset, block, offsetPosInWorld) -> {
                for (AABB partBlockShape : PlayerHitResult.getBoxesList(lv, offsetPosInWorld, block, mode, fluidMode, looker)) {
                    Vec3 res;
                    double dist;
                    Optional partHitResult = partBlockShape.m_82371_(eyePosition, reachVector);
                    if (!partHitResult.isPresent() || !((dist = eyePosition.m_82554_(res = (Vec3)partHitResult.get())) < (Double)distanceToPartOfBlock.get()) && !PlayerHitResult.isMainBlock((MorphedPlayerHitResult)((Object)((Object)result.get())), res, offsetPosInWorld)) continue;
                    distanceToPartOfBlock.set(dist);
                    Direction dir = PlayerHitResult.calculateHitDirection(res, partBlockShape);
                    if (dir == null) continue;
                    Vec3 inBlockOffset = new Vec3(res.m_7096_() - offsetPosInWorld.f_82479_, res.m_7098_() - offsetPosInWorld.f_82480_, res.m_7094_() - offsetPosInWorld.f_82481_);
                    result.set(MorphedPlayerHitResult.of(mob, offset, dir, inBlockOffset.f_82479_ == (double)((int)inBlockOffset.f_82479_) || inBlockOffset.f_82480_ == (double)((int)inBlockOffset.f_82480_) || inBlockOffset.f_82481_ == (double)((int)inBlockOffset.f_82481_), inBlockOffset, res));
                }
            }));
        }
        return (MorphedPlayerHitResult)((Object)result.get());
    }

    private static List<AABB> getBoxesList(Level lv, Vec3 offsetPosInWorld, BlockInPlayer2 block, ClipContext.Block mode, ClipContext.Fluid fluidMode, @Nullable Entity looker) {
        VoxelShape blockShape = mode.m_7544_(block.getBlockState(), (BlockGetter)lv, block.getPos(), looker != null ? CollisionContext.m_82750_((Entity)looker) : CollisionContext.m_82749_());
        blockShape = blockShape.m_83216_(offsetPosInWorld.f_82479_, offsetPosInWorld.f_82480_, offsetPosInWorld.f_82481_);
        ArrayList<AABB> boxes = new ArrayList<AABB>(blockShape.m_83299_());
        FluidState fluidState = block.getBlockState().m_60819_();
        if (block.shouldDoFluidAction() && fluidMode.m_45731_(fluidState)) {
            VoxelShape fluidShape = fluidState.m_76183_((BlockGetter)lv, block.getPos());
            fluidShape = fluidShape.m_83216_(offsetPosInWorld.f_82479_, offsetPosInWorld.f_82480_, offsetPosInWorld.f_82481_);
            boxes.addAll(fluidShape.m_83299_());
        }
        return boxes;
    }

    private static boolean isMainBlock(MorphedPlayerHitResult oldHit, Vec3 newVec, Vec3 newBlockOffsetInWorld) {
        return oldHit != null && oldHit.getRealLocation().equals((Object)newVec) && PlayerHitResult.containsAABB(CUBE.m_82383_(newBlockOffsetInWorld), newVec);
    }

    private static Direction calculateHitDirection(Vec3 hitVec, AABB boundingBox) {
        double xDist = Math.min(Math.abs(hitVec.f_82479_ - boundingBox.f_82288_), Math.abs(hitVec.f_82479_ - boundingBox.f_82291_));
        double yDist = Math.min(Math.abs(hitVec.f_82480_ - boundingBox.f_82289_), Math.abs(hitVec.f_82480_ - boundingBox.f_82292_));
        double zDist = Math.min(Math.abs(hitVec.f_82481_ - boundingBox.f_82290_), Math.abs(hitVec.f_82481_ - boundingBox.f_82293_));
        if (xDist < yDist && xDist < zDist) {
            return hitVec.f_82479_ < boundingBox.m_82399_().f_82479_ ? Direction.WEST : Direction.EAST;
        }
        if (yDist < xDist && yDist < zDist) {
            return hitVec.f_82480_ < boundingBox.m_82399_().f_82480_ ? Direction.DOWN : Direction.UP;
        }
        return hitVec.f_82481_ < boundingBox.m_82399_().f_82481_ ? Direction.NORTH : Direction.SOUTH;
    }

    private static boolean containsAABB(AABB ab, Vec3 tr) {
        double tolerance = 1.0E-7;
        double d = tr.f_82479_;
        double e = tr.f_82480_;
        double f = tr.f_82481_;
        return d >= ab.f_82288_ - tolerance && d <= ab.f_82291_ + tolerance && e >= ab.f_82289_ - tolerance && e <= ab.f_82292_ + tolerance && f >= ab.f_82290_ - tolerance && f <= ab.f_82293_ + tolerance;
    }

    public static void checkHitResult(Vec3 oldHitPos, ClipContext ctx, Consumer<MorphedPlayerHitResult> ifGood) {
        EntityCollisionContext context;
        Entity looker;
        CollisionContext collisionContext = ClipContextAccessor.of(ctx).getContext();
        if (collisionContext instanceof EntityCollisionContext && (looker = (context = (EntityCollisionContext)collisionContext).m_193113_()) != null) {
            Vec3 start = ctx.m_45702_();
            MorphedPlayerHitResult hit = PlayerHitResult.calculateMorphedPlayerHitResult(looker.m_9236_(), looker, start, ctx.m_45693_(), ClipContextAccessor.of(ctx).getMode(), ClipContextAccessor.of(ctx).getFluidMode());
            if (hit != null && start.m_82554_(hit.getRealLocation()) < start.m_82554_(oldHitPos)) {
                ifGood.accept(hit);
            }
        }
    }
}

