/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.tnt;

import javax.annotation.Nullable;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.EntityAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.dataSyncher.IntSyncedData;
import net.blockomorph.utils.tnt.TntSpawnLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class TntHandler {
    private final IntSyncedData BRAKE_PROGRESS;
    private PrimedTnt tnt;
    private final Player player;
    private final PlayerAccessor pl;

    public TntHandler(PlayerAccessor owner) {
        this.player = (Player)owner;
        this.pl = owner;
        this.BRAKE_PROGRESS = new IntSyncedData((Entity)owner.player(), MorphUtils.res("tnt_progress"), -1, this::onClientUpdater);
    }

    public void onDimensionChange() {
        Entity tnt1 = this.tnt.m_6095_().m_20615_(this.player.m_9236_());
        if (tnt1 instanceof PrimedTnt) {
            PrimedTnt tnt2 = (PrimedTnt)tnt1;
            if (!this.player.m_9236_().f_46443_) {
                tnt2.m_20361_((Entity)this.tnt);
                this.tnt = tnt2;
            }
        }
    }

    public void tick() {
        if (this.tnt != null) {
            if (!this.player.m_9236_().f_46443_ && this.tnt.m_9236_() != this.player.m_9236_()) {
                this.onDimensionChange();
                return;
            }
            ProfilerFiller profiler = this.player.m_9236_().m_46473_();
            profiler.m_6180_("morphedPlayerTntFuseTick");
            try {
                this.tnt.m_20343_(this.player.m_20185_(), this.player.m_20186_() + 0.06125, this.player.m_20189_());
                this.tnt.m_146867_();
                this.tnt.m_8119_();
                if (!this.player.m_9236_().f_46443_) {
                    this.setFuse(this.tnt.m_32100_());
                    if (!this.tnt.m_6084_()) {
                        if (Config.getInstance().getValue("playerDieAfterDestroy", Boolean.class).booleanValue()) {
                            MorphUtils.destroy(this.pl, null);
                        } else {
                            this.deMorph();
                        }
                        this.tnt = null;
                        this.setFuse(-1);
                    }
                }
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("Error while ticking TNT in morphed player " + this.player.m_5446_().getString(), (Throwable)e);
                this.deMorph();
            }
            finally {
                profiler.m_7238_();
            }
        }
        if (this.player.m_20094_() > 0 && !this.player.m_9236_().f_46443_) {
            this.runTnt();
        }
    }

    private void deMorph() {
        if (!this.player.m_9236_().f_46443_) {
            this.pl.applyBlockMorph(Blocks.f_50016_.m_49966_(), null, BannedBlock.Source.SYSTEM);
        }
    }

    public void setFuse(int i) {
        this.BRAKE_PROGRESS.set(i);
    }

    public boolean runTnt() {
        Block block;
        BlockState state;
        BlockInPlayer2 block2;
        if (this.pl.getBlocksData2().size() == 1 && this.pl.getBlocksData2().containsKey(InPlayerBlockPos.ZERO) && (block2 = this.pl.getBlocksData2().get(InPlayerBlockPos.ZERO)) != null && (state = this.pl.getBlockState(InPlayerBlockPos.ZERO)) != null && (block = state.m_60734_()) instanceof TntBlock) {
            TntBlock tntBlock = (TntBlock)block;
            if (this.tnt == null) {
                PrimedTnt TNT;
                TntSpawnLevel lv;
                block7: {
                    lv = new TntSpawnLevel(this.player.m_9236_(), state);
                    try {
                        tntBlock.onCaughtFire(state, (Level)lv, block2.getPos(), null, (LivingEntity)this.player);
                    }
                    catch (Exception e) {
                        TNT = lv.extractTnt();
                        if (TNT != null) break block7;
                        MorphUtils.LOGGER.error("Error while init TNT in morphed player " + this.player.m_5446_().getString(), (Throwable)e);
                        return false;
                    }
                }
                TNT = lv.extractTnt();
                Vec3 ps = MorphUtils.getRealBlockPos(this.pl, block2.getOffset());
                if (TNT == null) {
                    PrimedTnt primedtnt = new PrimedTnt(this.player.m_9236_(), ps.f_82479_ + 0.5, ps.f_82480_, ps.f_82481_ + 0.5, null);
                    this.player.m_9236_().m_6263_(null, primedtnt.m_20185_(), primedtnt.m_20186_(), primedtnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.player.m_9236_().m_220400_(null, GameEvent.f_157776_, ps);
                    this.tnt = primedtnt;
                } else {
                    TNT.m_146884_(ps);
                    this.tnt = TNT;
                }
                ((EntityAccessor)this.tnt).forceLevelChange(this.player.m_9236_());
                this.tnt.m_20242_(true);
                if (this.player.m_9236_().m_5776_()) {
                    double d0 = this.player.m_9236_().f_46441_.m_188500_() * 6.2831854820251465;
                    this.player.m_20256_(new Vec3(-Math.sin(d0) * 0.02, (double)0.3f, -Math.cos(d0) * 0.02));
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public InteractionResult clickTnt(Player clicker, InteractionHand hand, InPlayerBlockPos realPos) {
        BlockState state = this.pl.getBlockState(realPos);
        if (realPos.equals(InPlayerBlockPos.ZERO) && state != null && state.m_60734_() instanceof TntBlock) {
            ItemStack itemstack = clicker.m_21120_(hand);
            if (!itemstack.m_150930_(Items.f_42409_) && !itemstack.m_150930_(Items.f_42613_)) {
                return null;
            }
            if (!clicker.m_9236_().f_46443_ && !this.runTnt()) {
                return InteractionResult.FAIL;
            }
            Item item = itemstack.m_41720_();
            if (!clicker.m_7500_()) {
                if (itemstack.m_150930_(Items.f_42409_)) {
                    itemstack.m_41622_(1, (LivingEntity)clicker, pla -> pla.m_21190_(hand));
                } else {
                    itemstack.m_41774_(1);
                }
            }
            clicker.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.m_19078_((boolean)clicker.m_9236_().f_46443_);
        }
        return null;
    }

    public void onClientUpdater() {
        if (this.player.m_9236_().m_5776_()) {
            int i = (Integer)this.BRAKE_PROGRESS.get();
            if (i < 0) {
                this.tnt = null;
            } else {
                if (this.tnt == null) {
                    this.runTnt();
                }
                if (this.tnt != null) {
                    this.tnt.m_32085_(i);
                }
            }
        }
    }

    public void stopRunning() {
        this.tnt = null;
        this.setFuse(-1);
    }

    public PrimedTnt getTnt() {
        return this.tnt;
    }
}

