/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.blockomorph.network.ClientBoundApplyBlockMorphPacket;
import net.blockomorph.network.ClientBoundMorphUpdatePacket;
import net.blockomorph.network.ClientBoundServerBlockEntityTagPacket;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.HitBoxCalculator;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.MorphedPlayerRenderer;
import net.blockomorph.utils.MovementCalculator;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.tnt.TntHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerAccessor {
    @Shadow
    @Final
    private Abilities abilities;
    private final TntHandler TNT_HANDLER = new TntHandler(this);
    private final HitBoxCalculator HITBOX_HANDLER = new HitBoxCalculator(this);
    private final ConcurrentHashMap<InPlayerBlockPos, BlockInPlayer2> blocksData = new ConcurrentHashMap();
    private final Map<InPlayerBlockPos, BlockInPlayer2> unmodifiableBlocksData = Collections.unmodifiableMap(this.blocksData);
    private final List<InPlayerBlockPos> updates = new CopyOnWriteArrayList<InPlayerBlockPos>();
    private final ConcurrentHashMap<InPlayerBlockPos, BlockEventData> blocksEventsToTick = new ConcurrentHashMap();
    private boolean onLoadingBlocks;
    private boolean breakingMode;
    private boolean unContextedBreakingMode;

    @Shadow
    protected abstract boolean canPlayerFitWithinBlocksAndEntitiesWhen(Pose var1);

    @Override
    public boolean setBlockState(InPlayerBlockPos pos, BlockState state, int flags) {
        if (state.getBlock() == Blocks.AIR && this.isBreaking() && InPlayerBlockPos.ZERO.equals(pos)) {
            this.setBlockState(pos, Blocks.VOID_AIR.defaultBlockState(), flags);
        } else {
            BlockInPlayer2 old;
            if (pos == null || !pos.isValid() || (old = this.blocksData.get(pos)) != null && old.getBlockState() == state) {
                return false;
            }
            if (state.getBlock() == Blocks.AIR) {
                BlockInPlayer2 block = this.blocksData.get(pos);
                if (block != null) {
                    block.changeBlockState(state, flags);
                }
                this.blocksData.remove(pos);
            } else if (this.blocksData.containsKey(pos)) {
                this.blocksData.get(pos).changeBlockState(state, flags);
            } else {
                BlockInPlayer2 block = new BlockInPlayer2(this, pos, state, blockInPlayer -> this.blocksData.put(pos, (BlockInPlayer2)blockInPlayer));
                block.checkUpdates(flags, Blocks.AIR.defaultBlockState());
                block.onPlace(state, Blocks.AIR.defaultBlockState(), flags);
            }
        }
        this.HITBOX_HANDLER.recalculatePositions();
        this.refreshDimensions();
        return true;
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(InPlayerBlockPos pos) {
        if (this.blocksData == null) {
            return null;
        }
        BlockInPlayer2 bl = this.blocksData.get(pos);
        if (bl != null) {
            return bl.getBlockEntity();
        }
        return null;
    }

    @Override
    public CompoundTag getTag(InPlayerBlockPos pos) {
        BlockInPlayer2 ent = this.blocksData.get(pos);
        if (ent != null && ent.getBlockEntity() != null) {
            return ent.getBlockEntity().saveWithoutMetadata((HolderLookup.Provider)this.registryAccess());
        }
        return new CompoundTag();
    }

    @Override
    public BlockState getBlockState(InPlayerBlockPos pos) {
        if (this.blocksData == null) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockInPlayer2 bl = this.blocksData.get(pos);
        if (bl != null) {
            return bl.getBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    public Map<InPlayerBlockPos, BlockInPlayer2> getBlocksData2() {
        return this.unmodifiableBlocksData;
    }

    @Override
    public void prepareSync(InPlayerBlockPos pos) {
        if (!this.level().isClientSide && !this.updates.contains(pos)) {
            this.updates.add(pos);
        }
    }

    @Override
    public void prepareSync(InPlayerBlockPos pos, BlockEventData data) {
        if (!this.level().isClientSide && !this.blocksEventsToTick.containsKey(pos)) {
            this.blocksEventsToTick.put(pos, data);
        }
    }

    @Override
    public void breakingModeStart(boolean yes) {
        this.unContextedBreakingMode = yes;
        if (Config.getInstance().getValue("playerDieAfterDestroy", Boolean.class).booleanValue() || !yes) {
            this.breakingMode = yes;
        }
    }

    @Override
    public HitBoxCalculator getHitBoxHandler() {
        return this.HITBOX_HANDLER;
    }

    @Override
    public boolean isBreaking() {
        return this.breakingMode;
    }

    @Override
    public boolean isUnContextedBreaking() {
        return this.unContextedBreakingMode;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(ValueInput valueInput, CallbackInfo ci) {
        Optional old = valueInput.read("BlockMorph", CompoundTag.CODEC);
        if (old.isPresent()) {
            this.oldDataHandle((CompoundTag)old.get());
        } else {
            Optional data = valueInput.read("BlockoMorph", CompoundTag.CODEC);
            data.ifPresent(tag -> this.loadBlockData((CompoundTag)tag, null, true));
        }
    }

    @Override
    public void loadBlockData(CompoundTag blockomorph, @Nullable ClientBoundMorphUpdatePacket client, boolean first) {
        if (first) {
            this.blocksData.clear();
        }
        for (String key : blockomorph.keySet()) {
            InPlayerBlockPos pos = InPlayerBlockPos.parseBlockPos(key);
            if (pos == null) continue;
            CompoundTag tg = (CompoundTag)blockomorph.getCompound(key).orElseThrow();
            BlockState state = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tg.getCompound("BlockState").orElseGet(CompoundTag::new));
            CompoundTag tags = tg.getCompound("BlockEntityTag").orElseGet(CompoundTag::new);
            BlockInPlayer2 block = new BlockInPlayer2(this, pos, state, blockInPlayer -> this.blocksData.put(pos, (BlockInPlayer2)blockInPlayer));
            if (client != null) {
                block.handleClientTag(tags, client);
                continue;
            }
            block.loadNBT(tags);
        }
        this.HITBOX_HANDLER.recalculatePositions();
        this.refreshDimensions();
    }

    @Override
    public CompoundTag saveBlockData(boolean client) {
        CompoundTag blocks = new CompoundTag();
        this.blocksData.forEach((pos, data) -> {
            try {
                CompoundTag tg = new CompoundTag();
                tg.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)data.getBlockState()));
                BlockEntity ent = data.getBlockEntity();
                CompoundTag blockTag = new CompoundTag();
                if (ent != null) {
                    CompoundTag servTag = ent.saveWithoutMetadata((HolderLookup.Provider)this.registryAccess());
                    blockTag = client ? ent.getUpdateTag((HolderLookup.Provider)this.registryAccess()) : servTag;
                }
                tg.put("BlockEntityTag", (Tag)blockTag);
                blocks.put(pos.string(), (Tag)tg);
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while saving morphed player data on pos: {} for block: {} on player: {}", new Object[]{pos, data.getBlockState(), this.getName().getString(), e});
            }
        });
        return blocks;
    }

    @Override
    public boolean isOnLoadingBlocks() {
        return this.onLoadingBlocks;
    }

    @Override
    public void setOnLoadingBlocks(boolean yes) {
        this.onLoadingBlocks = yes;
    }

    private void oldDataHandle(CompoundTag tag) {
        if (!this.level().isClientSide) {
            BlockState state = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("BlockState").orElseGet(CompoundTag::new));
            CompoundTag tags = tag.getCompound("Tags").orElseGet(CompoundTag::new);
            InPlayerBlockPos pos = InPlayerBlockPos.ZERO;
            BlockInPlayer2 block = new BlockInPlayer2(this, pos, state, blockInPlayer -> this.blocksData.put(pos, (BlockInPlayer2)blockInPlayer));
            block.loadNBT(tags);
            this.HITBOX_HANDLER.recalculatePositions();
            this.refreshDimensions();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(ValueOutput valueOutput, CallbackInfo ci) {
        CompoundTag tg = this.saveBlockData(false);
        if (!tg.isEmpty()) {
            valueOutput.store("BlockoMorph", CompoundTag.CODEC, (Object)tg);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void attack(Entity entity, CallbackInfo ci) {
        PlayerAccessor pl;
        if (Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand) {
            return;
        }
        if (entity instanceof PlayerAccessor && (pl = (PlayerAccessor)entity).isActive()) {
            ci.cancel();
        }
    }

    @Inject(method={"updatePlayerPose"}, at={@At(value="HEAD")}, cancellable=true)
    public void updatePose(CallbackInfo ci) {
        this.getSleepingPos().ifPresent(pos -> {
            if (InPlayerBlockPos.isMorphedPlayerX(pos.getX()) && !this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.SWIMMING)) {
                this.setPose(Pose.SLEEPING);
                ci.cancel();
            }
        });
    }

    @Override
    public void sendNearby(Packet<?> packet) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel lv = (ServerLevel)level;
            ServerChunkCache cache = lv.getChunkSource();
            cache.broadcastAndSend((Entity)this.player(), packet);
        }
    }

    @Override
    public List<InPlayerBlockPos> getUpdates() {
        return Collections.unmodifiableList(this.updates);
    }

    @Override
    public void getBlocksData2InArea(AABB box, TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3> action) {
        if (action != null && box != null && this.getBoundingBox().intersects(box)) {
            Vec3 realPos = MorphUtils.getRealBlockPos((PlayerAccessor)this, InPlayerBlockPos.ZERO);
            int minX = Mth.floor((double)(box.minX - realPos.x));
            int minY = Mth.floor((double)(box.minY - realPos.y));
            int minZ = Mth.floor((double)(box.minZ - realPos.z));
            int maxX = Mth.floor((double)(box.maxX - realPos.x));
            int maxY = Mth.floor((double)(box.maxY - realPos.y));
            int maxZ = Mth.floor((double)(box.maxZ - realPos.z));
            for (int x = Math.max(-14, minX); x <= Math.min(14, maxX); ++x) {
                for (int y = Math.max(0, minY); y <= Math.min(30, maxY); ++y) {
                    for (int z = Math.max(-14, minZ); z <= Math.min(14, maxZ); ++z) {
                        InPlayerBlockPos pos = InPlayerBlockPos.get(x, y, z);
                        BlockInPlayer2 block = this.blocksData.get(pos);
                        if (block == null) continue;
                        action.accept((Object)pos, (Object)block, (Object)realPos.add(new Vec3((double)x, (double)y, (double)z)));
                    }
                }
            }
        }
    }

    @Override
    public void sendAllContentToPlayer(ServerPlayer target) {
        CompoundTag blocks = this.saveBlockData(true);
        CompoundTag buffer = new CompoundTag();
        ArrayList<ClientBoundMorphUpdatePacket> packets = new ArrayList<ClientBoundMorphUpdatePacket>();
        boolean first = true;
        for (String key : blocks.keySet()) {
            CompoundTag block = blocks.getCompoundOrEmpty(key);
            if (block.isEmpty()) continue;
            buffer.put(key, (Tag)block);
            if (buffer.sizeInBytes() <= 524288) continue;
            buffer.remove(key);
            packets.add(new ClientBoundMorphUpdatePacket(this, buffer, first));
            first = false;
            buffer = new CompoundTag();
            buffer.put(key, (Tag)block);
        }
        packets.add(new ClientBoundMorphUpdatePacket(this, buffer, first));
        for (ClientBoundMorphUpdatePacket packet : packets) {
            MorphUtils.sendPlayer(packet, target);
        }
    }

    private void runUpdates() {
        if (this.updates.isEmpty()) {
            return;
        }
        this.updates.forEach(realPos -> {
            BlockInPlayer2 block = this.blocksData.get(realPos);
            if (block == null) {
                BlockPos pos = realPos.boundedBlockPos(this.player());
                if (pos != null) {
                    this.sendNearby((Packet<?>)new ClientboundBlockUpdatePacket(pos, Blocks.AIR.defaultBlockState()));
                }
            } else {
                this.sendBockData(block);
            }
        });
        this.updates.clear();
    }

    private void sendBockData(BlockInPlayer2 block) {
        this.sendNearby((Packet<?>)new ClientboundBlockUpdatePacket(block.getPos(), block.getBlockState()));
        BlockEntity ent = block.getBlockEntity();
        if (ent != null) {
            try {
                if (ent.getUpdatePacket() != null) {
                    this.sendNearby(ent.getUpdatePacket());
                }
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while sending morphed player data on pos: " + String.valueOf(block.getOffset()) + " for block: " + String.valueOf(block.getBlockState()) + " on player: " + this.getName().getString(), (Throwable)e);
            }
        }
    }

    private void runUpdatesBlockEvents() {
        if (this.blocksEventsToTick.isEmpty()) {
            return;
        }
        this.blocksEventsToTick.forEach((realPos, data) -> {
            BlockInPlayer2 block = this.blocksData.get(realPos);
            if (block != null) {
                block.getBlockState().triggerEvent(this.level(), data.pos(), data.paramA(), data.paramB());
                this.sendNearby((Packet<?>)new ClientboundBlockEventPacket(data.pos(), data.block(), data.paramA(), data.paramB()));
            }
        });
        this.blocksEventsToTick.clear();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=true)
    public void tick(CallbackInfo ci) {
        if (!this.level().isClientSide) {
            this.runUpdates();
            this.runUpdatesBlockEvents();
        }
        if (this.isFullActive()) {
            ProfilerFiller profiler = Profiler.get();
            profiler.push("blockInMorphedPlayerTick");
            for (BlockInPlayer2 block : this.blocksData.values()) {
                block.tick();
            }
            profiler.pop();
        }
        this.TNT_HANDLER.tick();
        this.fluidCollisionUpdate();
    }

    private void fluidCollisionUpdate() {
        Block block;
        BlockState state = this.getBlockState(InPlayerBlockPos.ZERO);
        if (!this.abilities.flying && (block = state.getBlock()) instanceof LiquidBlock) {
            LiquidBlock block2 = (LiquidBlock)block;
            if (this.level().getBlockState(this.blockPosition()).getBlock() == block2) {
                Vec3 movement = this.getDeltaMovement();
                this.setDeltaMovement(movement.x, Math.min(1.8, movement.y + 0.3), movement.z);
                this.resetFallDistance();
            }
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void causeFallDamage(double f, float g, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Level level;
        if (this.isActive() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel lv = (ServerLevel)level;
            cir.cancel();
            if (!(this.getBlockState(InPlayerBlockPos.ZERO).getBlock() instanceof AnvilBlock)) {
                return;
            }
            int i = Mth.ceil((double)(f - 1.0));
            if (i < 0) {
                return;
            }
            Predicate predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
            DamageSource damageSource22 = this.damageSources().anvil((Entity)this);
            float h = Math.min(Mth.floor((float)((float)i * 2.0f)), 40);
            this.level().getEntities((Entity)this, this.getBoundingBox(), predicate).forEach(entity -> entity.hurtServer(lv, damageSource22, h));
        }
    }

    @Override
    @Nullable
    public BannedBlock applyBlockMorph(BlockState state, CompoundTag tag, BannedBlock.Source source) {
        InPlayerBlockPos pos2;
        BannedBlock mess = BannedBlock.isBannedBlock(state, this, source);
        if (mess != null) {
            return mess;
        }
        BlockState old = this.getBlockState(InPlayerBlockPos.ZERO);
        boolean flag = state.equals((Object)old);
        if (tag == null && flag) {
            return BannedBlock.ALREADY_MORPHED;
        }
        MorphUtils.sendPlayer(new ClientBoundApplyBlockMorphPacket(state, this), (ServerPlayer)this.player());
        this.onLoadingBlocks = true;
        for (InPlayerBlockPos pos2 : this.blocksData.keySet()) {
            if (pos2.equals(InPlayerBlockPos.ZERO)) continue;
            this.setBlockState(pos2, Blocks.AIR.defaultBlockState(), 3);
            this.updates.add(pos2);
        }
        this.setBlockState(InPlayerBlockPos.ZERO, state, 3);
        BlockInPlayer2 block = this.blocksData.get(InPlayerBlockPos.ZERO);
        if (block != null && tag != null) {
            List<String> errs = block.loadNBT(tag);
            ServerPlayer serverPlayer = (ServerPlayer)this.player();
            if (errs != null) {
                MorphUtils.sendPlayer(ClientBoundServerBlockEntityTagPacket.createForError(errs, true), serverPlayer);
            } else {
                CompoundTag newTag = this.getTag(InPlayerBlockPos.ZERO);
                if (!newTag.equals((Object)tag)) {
                    MorphUtils.sendPlayer(ClientBoundServerBlockEntityTagPacket.createForError(List.of(), false), serverPlayer);
                }
            }
        }
        if ((pos2 = InPlayerBlockPos.ZERO.boundedBlockPos(this.player())) != null) {
            state.getBlock().setPlacedBy(this.level(), (BlockPos)pos2, state, (LivingEntity)this, new ItemStack((ItemLike)state.getBlock().asItem(), 1));
        }
        this.updates.add(InPlayerBlockPos.ZERO);
        this.runUpdates();
        this.onLoadingBlocks = false;
        if (!this.level().isClientSide) {
            this.TNT_HANDLER.stopRunning();
        }
        return null;
    }

    @Override
    public PrimedTnt getTnt() {
        return this.TNT_HANDLER.getTnt();
    }

    @Override
    public void setTnt() {
        this.TNT_HANDLER.runTnt();
    }

    @Override
    public TntHandler getTntHandler() {
        return this.TNT_HANDLER;
    }

    @Override
    public boolean isActive() {
        return this.getBlockState(InPlayerBlockPos.ZERO).getBlock() != Blocks.AIR;
    }

    @Override
    public boolean isFullActive() {
        return this.isActive() && this.TNT_HANDLER.getTnt() == null;
    }

    @Override
    public InPlayerBlockPos minPos() {
        return this.HITBOX_HANDLER.getMinPos();
    }

    @Override
    public InPlayerBlockPos maxPos() {
        return this.HITBOX_HANDLER.getMaxPos();
    }

    @Override
    public int getBiggestProgress() {
        if (this.blocksData != null) {
            int progress = -1;
            for (BlockInPlayer2 block : this.blocksData.values()) {
                int k = MorphedPlayerRenderer.getBrakeProgress(block.getPos());
                if (k <= progress) continue;
                progress = k;
            }
            return progress;
        }
        return -1;
    }

    @Override
    public VoxelShape getShape(InPlayerBlockPos offset, @Nullable Vec3 realPos) {
        BlockInPlayer2 block = this.getBlocksData2().get(offset);
        if (block == null) {
            return Shapes.empty();
        }
        VoxelShape shp = block.getBlockState().getCollisionShape((BlockGetter)this.level(), block.getPos(), CollisionContext.of((Entity)this));
        Vec3 rl = realPos != null ? realPos : MorphUtils.getRealBlockPos((PlayerAccessor)this, offset);
        return shp.move(rl.x, rl.y, rl.z);
    }

    @Override
    public VoxelShape getRenderShape(InPlayerBlockPos pos, Player collisser) {
        BlockInPlayer2 block = this.getBlocksData2().get(pos);
        if (block == null) {
            return Shapes.empty();
        }
        BlockState state = block.getBlockState();
        VoxelShape shape = state.getShape((BlockGetter)this.level(), block.getPos(), CollisionContext.of((Entity)collisser));
        return shape.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (this.isActive()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getHurtSound(DamageSource damage, CallbackInfoReturnable<SoundEvent> cir) {
        if (this.isActive()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getFallSounds"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getFallSounds(CallbackInfoReturnable<LivingEntity.Fallsounds> cir) {
        if (this.isActive()) {
            cir.setReturnValue((Object)new LivingEntity.Fallsounds(SoundEvents.EMPTY, SoundEvents.EMPTY));
        }
    }

    @Inject(method={"maybeBackOffFromEdge"}, at={@At(value="RETURN")}, cancellable=true)
    public void fixMovement(Vec3 originalVector, MoverType moverType, CallbackInfoReturnable<Vec3> cir) {
        if (this.isActive() && (moverType == MoverType.PLAYER || moverType == MoverType.SELF)) {
            MovementCalculator calculator = new MovementCalculator(this);
            calculator.calculateEnterCorrection(originalVector);
        }
    }

    @Inject(method={"getDefaultDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        if (this.isActive()) {
            cir.setReturnValue((Object)this.HITBOX_HANDLER.calculateDimensions());
        }
    }

    public PlayerMixin() {
        super(null, null);
    }
}

