/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client;

import com.llamalad7.mixinextras.sugar.Local;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.InputEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class AttackSupportMixin {
    @Shadow
    @Nullable
    public HitResult hitResult;
    @Shadow
    public MultiPlayerGameMode gameMode;
    @Shadow
    public LocalPlayer player;

    @Inject(method={"startAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z")}, cancellable=true)
    public void attack(CallbackInfoReturnable<Boolean> cir, @Local InputEvent.InteractionKeyMappingTriggered input) {
        MorphedPlayerHitResult hit;
        HitResult hitResult = this.hitResult;
        if (hitResult instanceof MorphedPlayerHitResult && (hit = (MorphedPlayerHitResult)hitResult).getPlayer().isFullActive()) {
            Config.HitReaction hitReaction = Config.getInstance().getValue("hitReaction", Config.HitReaction.class);
            boolean needSwing = false;
            if (hitReaction != Config.HitReaction.BRAKING) {
                cir.setReturnValue((Object)true);
                needSwing = true;
            }
            if (hitReaction.hand) {
                this.gameMode.attack((Player)this.player, (Entity)hit.getPlayer().player());
            } else if (hitReaction != Config.HitReaction.BRAKING) {
                this.player.resetAttackStrengthTicker();
            }
            if (needSwing && input.shouldSwingHand()) {
                this.player.swing(InteractionHand.MAIN_HAND);
            }
        }
    }

    @ModifyVariable(method={"continueAttack"}, at=@At(value="HEAD"))
    public boolean check(boolean needContinue) {
        Config.HitReaction hitReaction;
        MorphedPlayerHitResult hit;
        HitResult hitResult;
        if (needContinue && (hitResult = this.hitResult) instanceof MorphedPlayerHitResult && (hit = (MorphedPlayerHitResult)hitResult).getPlayer().isFullActive() && (hitReaction = Config.getInstance().getValue("hitReaction", Config.HitReaction.class)) != Config.HitReaction.BRAKING) {
            return false;
        }
        return needContinue;
    }
}

