/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client;

import com.llamalad7.mixinextras.sugar.Local;
import net.blockomorph.screens.morph.ConfigSyncListener;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin {
    @Inject(method={"handlePlayerCombatKill"}, at={@At(value="HEAD")}, cancellable=true)
    public void autoRespawn(ClientboundPlayerCombatKillPacket packet, CallbackInfo ci) {
        LocalPlayer player = Minecraft.getInstance().player;
        Entity entity = player.level().getEntity(packet.playerId());
        if (entity == player && PlayerAccessor.of((Player)player).isActive()) {
            ci.cancel();
            player.respawn();
        }
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="TAIL")})
    private void onOpUpdate(ClientboundEntityEventPacket clientboundEntityEventPacket, CallbackInfo ci, @Local Entity entity) {
        Screen screen;
        if (entity == GuiUtils.MC.player && (screen = GuiUtils.MC.screen) instanceof ConfigSyncListener) {
            ConfigSyncListener sc = (ConfigSyncListener)screen;
            sc.onOperatorRightsChanged();
        }
    }

    @Redirect(method={"handleSetEntityPassengersPacket(Lnet/minecraft/network/protocol/game/ClientboundSetPassengersPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;setOverlayMessage(Lnet/minecraft/network/chat/Component;Z)V"))
    private void redirectSetOverlayMessage(Gui instance, Component component, boolean bl) {
        if (this.needEjectMessage()) {
            instance.setOverlayMessage(component, bl);
        }
    }

    @Redirect(method={"handleSetEntityPassengersPacket(Lnet/minecraft/network/protocol/game/ClientboundSetPassengersPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/GameNarrator;saySystemNow(Lnet/minecraft/network/chat/Component;)V"))
    private void redirectSayNow(GameNarrator instance, Component component) {
        if (this.needEjectMessage()) {
            instance.saySystemNow(component);
        }
    }

    private boolean needEjectMessage() {
        Entity entity;
        LocalPlayer pl = Minecraft.getInstance().player;
        if (pl != null && (entity = pl.getVehicle()) instanceof PlayerAccessor) {
            PlayerAccessor playerAccessor = (PlayerAccessor)entity;
            return !playerAccessor.isFullActive();
        }
        return true;
    }
}

