/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client.graphic.entity;

import java.util.Optional;
import net.blockomorph.utils.accessors.RenderStateAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin<T extends HumanoidRenderState> {
    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/HumanoidRenderState;)V"}, at={@At(value="HEAD")})
    public void fixRiding(T humanoidRenderState, CallbackInfo ci) {
        this.fix((HumanoidRenderState)humanoidRenderState, () -> {
            humanoidRenderState.isPassenger = false;
        });
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/HumanoidRenderState;)V"}, at={@At(value="TAIL")})
    public void fixRiding2(T humanoidRenderState, CallbackInfo ci) {
        this.fix((HumanoidRenderState)humanoidRenderState, () -> {
            ((HumanoidModel)this).head.yRot = 0.0f;
        });
    }

    @Unique
    private void fix(HumanoidRenderState livingEntity, Runnable cons) {
        if (livingEntity instanceof RenderStateAccessor) {
            RenderStateAccessor acc = (RenderStateAccessor)livingEntity;
            Optional pos = acc.getPlayer().getSleepingPos();
            pos.ifPresent(blockpos -> {
                if (InPlayerBlockPos.isMorphedPlayerX(blockpos.getX())) {
                    cons.run();
                }
            });
        }
    }
}

