/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client.graphic.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.blockomorph.utils.MorphedPlayerRenderer;
import net.blockomorph.utils.accessors.RenderStateAccessor;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingRendererMixin<T extends LivingEntity, S extends LivingEntityRenderState>
extends EntityRenderer {
    private final Consumer<Float> SHADOW = value -> {
        this.shadowRadius = value.floatValue();
    };
    private final MorphedPlayerRenderer RENDERER = new MorphedPlayerRenderer();

    public LivingRendererMixin() {
        super(null);
    }

    @Inject(method={"render(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(S livingEntityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        if (livingEntityRenderState instanceof RenderStateAccessor) {
            RenderStateAccessor acc = (RenderStateAccessor)livingEntityRenderState;
            this.shadowRadius = 0.5f;
            if (this.RENDERER.render(false, acc.getPlayer(), acc.tick().floatValue(), poseStack, multiBufferSource, i, this.SHADOW)) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;F)V"}, at={@At(value="TAIL")})
    public void extractRenderState(T abstractClientPlayer, S playerRenderState, float f, CallbackInfo ci) {
        if (playerRenderState instanceof RenderStateAccessor) {
            RenderStateAccessor r = (RenderStateAccessor)playerRenderState;
            if (abstractClientPlayer instanceof AbstractClientPlayer) {
                AbstractClientPlayer player = (AbstractClientPlayer)abstractClientPlayer;
                r.loadPlayer(player);
                r.tick().setValue(f);
                if (r.getPl().isFullActive()) {
                    ((LivingEntityRenderState)playerRenderState).hitboxesRenderState = null;
                    ((LivingEntityRenderState)playerRenderState).serverHitboxesRenderState = null;
                }
            }
        }
    }
}

