/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.level;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.blockomorph.utils.accessors.LevelAcc;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelInjectsMixin {
    @Inject(method={"isInWorldBoundsHorizontal"}, at={@At(value="HEAD")}, cancellable=true)
    private static void acceptIfPlayerPos(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.getX())) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at=@At(value="HEAD"))
    public BlockState changeState(BlockState original, BlockPos pos) {
        AtomicReference<BlockState> value = new AtomicReference<BlockState>(original);
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            boolean lockLiquid;
            boolean isLiquid = original.getBlock() instanceof LiquidBlock;
            boolean bl = lockLiquid = isLiquid && pl.isUnContextedBreaking();
            if (pl.isBreaking() && realPos.equals(InPlayerBlockPos.ZERO) && (original == Blocks.AIR.defaultBlockState() || lockLiquid)) {
                value.set(Blocks.VOID_AIR.defaultBlockState());
            } else if (lockLiquid) {
                value.set(Blocks.AIR.defaultBlockState());
            }
        }, null, (LevelReader)LevelAcc.of(this));
        return value.get();
    }

    @ModifyVariable(method={"destroyBlock", "removeBlock"}, at=@At(value="STORE"))
    private FluidState changeFluid(FluidState orig, BlockPos pos) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.getX())) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return orig;
    }

    @ModifyVariable(method={"markAndNotifyBlock"}, at=@At(value="STORE"), ordinal=2)
    public BlockState getState(BlockState value, BlockPos pos) {
        AtomicReference<BlockState> state = new AtomicReference<BlockState>(value);
        InPlayerBlockPos.check(pos, (pl, realPos) -> state.set(pl.getBlockState((InPlayerBlockPos)realPos)), null, (LevelReader)LevelAcc.of(this));
        return state.get();
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void rejectBreak(BlockPos pos, BlockState blockState, int i, int j, CallbackInfoReturnable<Boolean> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            if (pl.isOnLoadingBlocks() && blockState == Blocks.AIR.defaultBlockState() && realPos.equals(InPlayerBlockPos.ZERO)) {
                cir.setReturnValue((Object)false);
            }
        }, () -> cir.setReturnValue((Object)false), (LevelReader)LevelAcc.of(this));
    }

    @ModifyVariable(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at=@At(value="HEAD"))
    private Predicate<Entity> eraseOwner(Predicate<Entity> original, Entity ent, AABB aabb) {
        AtomicReference player = new AtomicReference();
        InPlayerBlockPos.check(BlockPos.containing((Position)aabb.getCenter()), (pl, realPos) -> player.set(pl.player()), null, (LevelReader)LevelAcc.of(this));
        return original.and(entity -> entity != player.get());
    }

    @ModifyVariable(method={"getEntities(Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;Ljava/util/List;I)V"}, at=@At(value="HEAD"))
    private <T extends Entity> Predicate<Entity> eraseOwner(Predicate<Entity> original, EntityTypeTest<Entity, T> type, AABB aabb) {
        AtomicReference player = new AtomicReference();
        InPlayerBlockPos.check(BlockPos.containing((Position)aabb.getCenter()), (pl, realPos) -> player.set(pl.player()), null, (LevelReader)LevelAcc.of(this));
        return original.and(entity -> entity != player.get());
    }
}

