/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.network.ClientBoundBlockPosBoundPacket;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.PlayerMorphedSection;
import net.blockomorph.utils.dataSyncher.SyncedEntity;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public class ServerEntityMixin {
    @Shadow
    @Final
    private Entity entity;
    @Shadow
    @Final
    private ServerLevel level;

    @Inject(method={"sendChanges"}, at={@At(value="INVOKE", target="Ljava/util/function/BiConsumer;accept(Ljava/lang/Object;Ljava/lang/Object;)V", shift=At.Shift.AFTER)})
    private void fixAsync(CallbackInfo ci) {
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            pl.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)pl));
        }
    }

    @Inject(method={"addPairing"}, at={@At(value="TAIL")})
    public void start(ServerPlayer looker, CallbackInfo ci) {
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            entity = this.entity;
            if (entity instanceof PlayerAccessor) {
                PlayerAccessor acc = (PlayerAccessor)entity;
                PlayerMorphedSection pos = BlockPosBounds.getChunkPosForPlayer((Player)pl);
                if (pos != null) {
                    MorphUtils.sendPlayer(new ClientBoundBlockPosBoundPacket(pos, (Player)pl, false), looker);
                }
                acc.sendAllContentToPlayer(looker);
            }
        }
        SyncedEntity.of(this.entity).checkOrSendImmediate(this::sendCustomPacket, true);
    }

    @Inject(method={"sendChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getPassengers()Ljava/util/List;")})
    public void sync(CallbackInfo ci) {
        SyncedEntity.of(this.entity).checkOrSendImmediate(this::sendCustomPacket, false);
    }

    @Inject(method={"removePairing"}, at={@At(value="TAIL")})
    public void stop(ServerPlayer looker, CallbackInfo ci) {
        ServerPlayer pl;
        PlayerMorphedSection pos;
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer && (pos = BlockPosBounds.getChunkPosForPlayer((Player)(pl = (ServerPlayer)entity))) != null) {
            MorphUtils.sendPlayer(new ClientBoundBlockPosBoundPacket(pos, (Player)pl, true), looker);
        }
    }

    private void sendCustomPacket(BlockMorphPacket packet) {
        this.level.getChunkSource().chunkMap.getPlayers(this.entity.chunkPosition(), false).forEach(player -> MorphUtils.sendPlayer(packet, player));
    }
}

