/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import java.util.List;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriConsumer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerPacketListenerMixin {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"noBlocksAround"}, at={@At(value="RETURN")}, cancellable=true)
    public void test(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            AABB roundAABB = entity.getBoundingBox().inflate(0.0625).expandTowards(0.0, -0.55, 0.0);
            List entities = this.player.level().getEntities(entity, roundAABB);
            for (Entity ent : entities) {
                PlayerAccessor pl;
                if (!((Boolean)cir.getReturnValue()).booleanValue()) {
                    return;
                }
                if (!(ent instanceof PlayerAccessor) || !(pl = (PlayerAccessor)ent).isFullActive()) continue;
                pl.getBlocksData2InArea(roundAABB, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(realPos, block, vec3) -> cir.setReturnValue((Object)false)));
            }
        }
    }

    @Inject(method={"isEntityCollidingWithAnythingNew"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkCollision(LevelReader levelReader, Entity entity, AABB playerBox, double moveX, double moveY, double moveZ, CallbackInfoReturnable<Boolean> cir) {
        AABB movedBox = entity.getBoundingBox().move(moveX - entity.getX(), moveY - entity.getY(), moveZ - entity.getZ());
        Iterable collisions = levelReader.getCollisions(entity, movedBox.deflate((double)1.0E-5f));
        boolean isAlreadyInsideShape = false;
        boolean isTryingToEnterShape = false;
        for (VoxelShape collisionShape : collisions) {
            if (Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)playerBox.deflate((double)1.0E-5f)), (VoxelShape)collisionShape, (BooleanOp)BooleanOp.AND)) {
                isAlreadyInsideShape = true;
            }
            if (!Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)movedBox.deflate((double)1.0E-5f)), (VoxelShape)collisionShape, (BooleanOp)BooleanOp.AND)) continue;
            isTryingToEnterShape = true;
        }
        if (isTryingToEnterShape && !isAlreadyInsideShape) {
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"handleUseItemOn"}, at={@At(ordinal=1, value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V")}, cancellable=true)
    private void redirectUpdate(ServerboundUseItemOnPacket packet, CallbackInfo ci) {
        BlockHitResult res = packet.getHitResult();
        BlockPos pos = res.getBlockPos().relative(res.getDirection());
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            ci.cancel();
            this.player.connection.send((Packet)new ClientboundBlockUpdatePacket(pos, pl.getBlockState((InPlayerBlockPos)realPos)));
        }, null, (LevelReader)this.player.level());
    }

    @Inject(method={"handleUseItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isItemEnabled(Lnet/minecraft/world/flag/FeatureFlagSet;)Z")}, cancellable=true)
    public void checkAccess(ServerboundUseItemOnPacket pkt, CallbackInfo ci) {
        BlockHitResult hit = pkt.getHitResult();
        InPlayerBlockPos.check(hit.getBlockPos(), (pl, realPos) -> {
            if (!pl.isActive()) {
                ci.cancel();
            }
        }, null, (LevelReader)this.player.level());
        if (!ci.isCancelled() && MorphUtils.needRejectUse((Level)this.player.level(), hit)) {
            ci.cancel();
        }
    }

    @Inject(method={"handleInteract"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")}, cancellable=true)
    public void checkAccess(ServerboundInteractPacket pkt, CallbackInfo ci) {
        PlayerAccessor pl;
        Entity entity = pkt.getTarget(this.player.level());
        if (entity instanceof PlayerAccessor && (pl = (PlayerAccessor)entity).isActive() && !Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand) {
            ci.cancel();
        }
    }

    @Inject(method={"handlePlayerAction"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")}, cancellable=true)
    public void checkAccess(ServerboundPlayerActionPacket pkt, CallbackInfo ci) {
        switch (pkt.getAction()) {
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                InPlayerBlockPos.check(pkt.getPos(), (pl, realPos) -> {
                    if (!pl.isFullActive() || Config.getInstance().getValue("hitReaction", Config.HitReaction.class) != Config.HitReaction.BRAKING) {
                        ci.cancel();
                    }
                }, null, (LevelReader)this.player.level());
            }
        }
    }

    @ModifyVariable(method={"teleport(Lnet/minecraft/world/entity/PositionMoveRotation;Ljava/util/Set;)V"}, at=@At(value="HEAD"))
    public PositionMoveRotation normalizePos(PositionMoveRotation value) {
        Vec3 vec = value.position();
        if (InPlayerBlockPos.isMorphedPlayerX(vec.x)) {
            return new PositionMoveRotation(InPlayerBlockPos.checkOnReal(vec), value.deltaMovement(), value.yRot(), value.xRot());
        }
        return value;
    }
}

