/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import com.mojang.authlib.GameProfile;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Shadow
    public abstract boolean startRiding(Entity var1, boolean var2);

    public ServerPlayerMixin(Level p_250508_, GameProfile p_252153_) {
        super(p_250508_, p_252153_);
    }

    @ModifyVariable(method={"setRespawnPosition"}, at=@At(value="HEAD"))
    private ServerPlayer.RespawnConfig modifyBlockPos(ServerPlayer.RespawnConfig originalPos) {
        if (originalPos == null) {
            return null;
        }
        BlockPos newPos = InPlayerBlockPos.checkOnReal(originalPos.pos());
        return new ServerPlayer.RespawnConfig(originalPos.dimension(), newPos, originalPos.angle(), newPos != originalPos.pos() || originalPos.forced());
    }

    @Inject(method={"startSleeping"}, at={@At(value="TAIL")})
    public void bound(BlockPos pos, CallbackInfo ci) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> this.startRiding((Entity)pl.player(), true), null, (LevelReader)this.level());
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="HEAD")})
    public void unbound(boolean p_9165_, boolean p_9166_, CallbackInfo ci) {
        this.getSleepingPos().ifPresent(blockpos -> {
            if (InPlayerBlockPos.isMorphedPlayerX(blockpos.getX())) {
                this.stopRiding();
            }
        });
    }

    @Inject(method={"isReachableBedBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void realInRange(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.getX())) {
            Vec3 real = InPlayerBlockPos.checkOnReal(Vec3.atBottomCenterOf((Vec3i)pos));
            cir.setReturnValue((Object)(Math.abs(this.getX() - real.x()) <= 3.0 && Math.abs(this.getY() - real.y()) <= 2.0 && Math.abs(this.getZ() - real.z()) <= 3.0 ? 1 : 0));
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    public void dead(DamageSource damageSource, CallbackInfo ci) {
        if (PlayerAccessor.of(this).isFullActive() && !damageSource.is(MorphUtils.PLAYER_DESTROYED) && !damageSource.is(MorphUtils.PLAYER_DESTROYED_NULL)) {
            PlayerAccessor.of(this).getBlocksData2().values().forEach(block -> this.level().levelEvent(2001, block.getPos(), Block.getId((BlockState)block.getBlockState())));
        }
    }

    @Inject(method={"restoreFrom"}, at={@At(value="TAIL")})
    public void restoreBlockMorphData(ServerPlayer old, boolean fromEnd, CallbackInfo ci) {
        PlayerAccessor pl = PlayerAccessor.of(this);
        PlayerAccessor oldPl = PlayerAccessor.of((Player)old);
        if (!fromEnd && Config.getInstance().getValue("playerDieAfterDestroy", Boolean.class).booleanValue()) {
            pl.applyBlockMorph(Blocks.AIR.defaultBlockState(), null, BannedBlock.Source.SYSTEM);
            for (InPlayerBlockPos pos : oldPl.getUpdates()) {
                pl.prepareSync(pos);
            }
        } else {
            pl.loadBlockData(oldPl.saveBlockData(false), null, true);
        }
    }

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(ServerLevel lv, DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (MorphUtils.onPlayerAttacked(damageSource, (Entity)this)) {
            cir.setReturnValue((Object)false);
        }
    }
}

