/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.network;

import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.screens.morph.ConfigSyncListener;
import net.blockomorph.utils.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class ClientBoundConfigUpdatePacket
implements BlockMorphPacket {
    public static final String ID = "client_bound_config_update_packet";
    Config config;

    public ClientBoundConfigUpdatePacket(FriendlyByteBuf buf) {
        this.config = Config.readFromBuffer(buf);
    }

    public ClientBoundConfigUpdatePacket(Config cfg) {
        this.config = cfg;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.config.writeInBuffer(buffer);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void handle(Player player) {
        Screen screen;
        if (!Minecraft.getInstance().isLocalServer()) {
            Config.loadExternal(this.config);
        }
        if ((screen = Minecraft.getInstance().screen) instanceof ConfigSyncListener) {
            ConfigSyncListener gui = (ConfigSyncListener)screen;
            gui.onConfigSynced();
        }
    }
}

