/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.network;

import java.util.List;
import java.util.Objects;
import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.screens.morphConfig.nbtEditor.PlayerBlockEntityNbtEditor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ClientBoundServerBlockEntityTagPacket
implements BlockMorphPacket {
    public static final String ID = "client_bound_server_block_entity_packet";
    CompoundTag tagForGui;
    boolean message;

    private ClientBoundServerBlockEntityTagPacket(CompoundTag tagForGui, boolean message) {
        this.tagForGui = tagForGui;
        this.message = message;
    }

    public ClientBoundServerBlockEntityTagPacket(FriendlyByteBuf buffer) {
        this.tagForGui = buffer.readNbt();
        this.message = buffer.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeNbt((Tag)this.tagForGui);
        buffer.writeBoolean(this.message);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void handle(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof PlayerBlockEntityNbtEditor) {
            PlayerBlockEntityNbtEditor nbtEditor = (PlayerBlockEntityNbtEditor)screen;
            if (this.message) {
                if (this.tagForGui != null) {
                    boolean exc = this.tagForGui.getBooleanOr("exc", false);
                    if (!exc) {
                        nbtEditor.setError(List.of(Component.translatable((String)"blockomorph.gui.nbtEditor.parseError.save").getString()));
                    } else {
                        List<String> errors = this.tagForGui.getListOrEmpty("err").stream().map(tag -> {
                            if (!(tag instanceof StringTag)) return null;
                            StringTag $b$0 = (StringTag)tag;
                            try {
                                String patt1$temp = $b$0.value();
                                return patt1$temp;
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                        }).filter(Objects::nonNull).toList();
                        nbtEditor.setError(errors);
                    }
                }
            } else {
                nbtEditor.setNewTag(this.tagForGui);
            }
        }
    }

    public static ClientBoundServerBlockEntityTagPacket createForTag(CompoundTag tag) {
        return new ClientBoundServerBlockEntityTagPacket(tag, false);
    }

    public static ClientBoundServerBlockEntityTagPacket createForError(List<String> errors, boolean isException) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        list.addAll(errors.stream().map(StringTag::valueOf).toList());
        tag.put("err", (Tag)list);
        tag.putBoolean("exc", isException);
        return new ClientBoundServerBlockEntityTagPacket(tag, true);
    }
}

