/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers;

import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers.AbstractInterpritationTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.blockstate.BlockStateSelectorOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.CompoundTagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateTagRenderer
extends AbstractInterpritationTagRenderer<CompoundTag> {
    private static final int BUTTON_SIZE = 16;
    private BlockState state;
    private BlockEntity tempBE;
    private boolean hovered;

    public BlockStateTagRenderer(CompoundTagRenderer parent, TagRendererContext<CompoundTag> ctx) {
        super(parent, ctx);
        this.state = NbtUtils.readBlockState((HolderGetter)ctx.provider().lookupOrThrow(Registries.BLOCK), (CompoundTag)((CompoundTag)parent.getTag()));
        this.setTempBE();
    }

    private void setTempBE() {
        Block block = this.state.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock ent = (EntityBlock)block;
            v0 = ent.newBlockEntity(GuiUtils.AIR, this.state);
        } else {
            v0 = this.tempBE = null;
        }
        if (this.tempBE != null) {
            this.tempBE.setLevel((Level)GuiUtils.MC.level);
        }
    }

    @Override
    public void renderMain(GuiUtils gui) {
        int x = this.box.getX() + this.box.getWidth() - 29 - 16;
        int y = this.box.getY() + 2;
        this.hovered = GuiUtils.isMouseOver(x, y, x + 16, y + 16, gui.getMouseX(), gui.getMouseY());
        if (this.hovered) {
            gui.blit(TAGS_SPRITE, x, y, 144.0f, 46.0f, 16, 16, 194, 200);
        }
        gui.renderBlockInGui(this.state, this.tempBE, (float)x + 13.75f, (float)(y + 16) - 4.5f, 8.0f);
        gui.renderAdditionalOnBlock(this.state, x, y, 14.0f);
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY) {
        if (this.hovered) {
            this.tagRendererContext.onTagEditingRequested().accept(new BlockStateSelectorOverlay(this.state, this::changeBlockState));
            GuiUtils.playClickSound();
            return true;
        }
        return false;
    }

    @Override
    public Component getTooltip(GuiUtils gui) {
        if (this.hovered) {
            return this.state.getBlock().getName();
        }
        return super.getTooltip(gui);
    }

    private void changeBlockState(BlockState state) {
        this.state = state;
        this.setTempBE();
        CompoundTag tag = NbtUtils.writeBlockState((BlockState)state);
        this.changeThis(tag);
    }

    @Override
    protected Integer getPlateNumber() {
        return 5;
    }
}

