/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;

public abstract class TagEditingOverlay
extends AbstractContainerEventHandler {
    protected int width;
    protected int height;
    protected int imageLength;
    protected int imageHeight;
    protected Consumer<TagEditingOverlay> onChange;
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();

    public TagEditingOverlay(int imageLength, int imageHeigth) {
        this.imageLength = imageLength;
        this.imageHeight = imageHeigth;
    }

    public void init(int width, int height, Consumer<TagEditingOverlay> onChange) {
        this.widgets.clear();
        this.width = width;
        this.height = height;
        this.onChange = onChange;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int type) {
        if (this.closeOnEmptyClick(mouseX, mouseY, type)) {
            this.onChange.accept(null);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, type);
    }

    protected boolean closeOnEmptyClick(double mouseX, double mouseY, int type) {
        if (type == 0) {
            int x = this.width / 2 - this.imageLength / 2;
            int y = this.height / 2 - this.imageHeight / 2;
            return !GuiUtils.isMouseOver(x, y, x + this.imageLength, y + this.imageHeight, mouseX, mouseY);
        }
        return false;
    }

    public final void render(GuiUtils gui) {
        this.renderBackground(gui);
        this.widgets.forEach(widget -> widget.render(gui.getGuiGraphics(), gui.getMouseX(), gui.getMouseY(), gui.getTick()));
        this.renderInGui(gui);
    }

    protected abstract void renderInGui(GuiUtils var1);

    protected abstract void renderBackground(GuiUtils var1);

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    protected void addRenderableWidget(AbstractWidget widget) {
        this.widgets.add(widget);
    }
}

