/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers;

import com.mojang.brigadier.Message;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.blockomorph.screens.morphConfig.nbtEditor.TagTypes;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagAddingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive.NumericTagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class CollectionTagRenderer<LIST extends CollectionTag>
extends TagRenderer<LIST> {
    private static final int BUTTON_SIZE = 16;
    private final TagType<?>[] allowedTypes;
    private static final List<Component> HINT = Stream.of(Component.translatable((String)"blockomorph.gui.nbtEditor.addOverlay.hint.collectionTag").getString().split("\n")).map(word -> Component.translationArg((Message)Component.literal((String)word))).toList();
    private boolean hovered;
    private final int color;

    protected CollectionTagRenderer(String tagName, LIST tag, TagRendererContext<LIST> ctx, int color, TagType<?> ... allowedTypes) {
        super(tagName, tag, ctx);
        this.color = color;
        this.allowedTypes = allowedTypes;
    }

    @Override
    public void renderPlate(GuiUtils gui, int number) {
        gui.fill(this.box.getX(), this.box.getY(), this.box.getX() + this.box.getWidth(), this.box.getY() + this.box.getHeight(), this.color);
        super.renderPlate(gui, number);
    }

    @Override
    public void render(GuiUtils gui) {
        int x = this.box.getX() + (this.hasName() ? 61 : this.box.getWidth() - 3 - 16);
        int y = this.box.getY() + 2;
        this.hovered = GuiUtils.isMouseOver(x, y, x + 16, y + 16, gui.getMouseX(), gui.getMouseY());
        gui.blit(TAGS_SPRITE, x, y, 160.0f, this.hovered ? 16.0f : 0.0f, 16, 16, 194, 200);
    }

    @Override
    protected void renderLine(GuiUtils gui, int number) {
        this.renderDynamicColorLine(gui);
    }

    @Override
    public boolean canEnterInTag() {
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY) {
        if (this.hovered) {
            this.enterInTag();
            GuiUtils.playClickSound();
            return true;
        }
        return false;
    }

    @Override
    protected Integer getPlateNumber() {
        return 3;
    }

    @Override
    public int getFrameColor() {
        return this.color;
    }

    @Override
    public List<TagRenderer<?>> getEnteringTags() {
        ArrayList renderers = new ArrayList();
        int i = 1;
        for (Tag tag : (CollectionTag)this.getTag()) {
            if (tag == null) continue;
            int index = i++;
            TagRenderer<Tag> renderer = TagTypes.getRendererForTag("" + index, tag, this.tagRendererContext.withTagUpdateListener(newTag -> ((CollectionTag)this.getTag()).setTag(index - 1, newTag)));
            renderers.add(renderer);
        }
        return renderers;
    }

    @Override
    public Tag tryWalk(String nameElementInThisTag) {
        try {
            int index = Integer.parseInt(nameElementInThisTag) - 1;
            return ((CollectionTag)this.getTag()).get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public TagEditingOverlay getTagAddOverlay() {
        return new TagAddingOverlay<Tag>(name -> {
            if (name.isEmpty()) {
                return true;
            }
            try {
                int index = Integer.parseInt(name) - 1;
                if (index >= 0 && index < ((CollectionTag)this.getTag()).size()) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return false;
        }, (name, tag) -> {
            int index = name.isEmpty() ? ((CollectionTag)this.getTag()).size() : Integer.parseInt(name) - 1;
            this.signalChange(() -> ((CollectionTag)this.getTag()).addTag(index, tag), false, index + 1);
        }, this::getAddOverlayHint, HINT, true, this.allowedTypes);
    }

    private String getAddOverlayHint() {
        if (((CollectionTag)this.getTag()).isEmpty()) {
            return "*Adding to end*";
        }
        if (((CollectionTag)this.getTag()).size() == 1) {
            return "1";
        }
        return "1-" + ((CollectionTag)this.getTag()).size();
    }

    @Override
    public void deleteTag(String name) {
        try {
            int index = Integer.parseInt(name);
            if (index - 1 < ((CollectionTag)this.getTag()).size() && index - 1 >= 0) {
                this.signalChange(() -> ((CollectionTag)this.getTag()).remove(index - 1), true, index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void signalChange(Runnable action, boolean delete, int userFormatIndex) {
        List<Integer> numbersOld = this.getNumberList();
        action.run();
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>();
        for (int number : numbersOld) {
            if (number == userFormatIndex) continue;
            map.put((CallSite)((Object)("" + number)), (CallSite)((Object)("" + (number > userFormatIndex ? number + (delete ? -1 : 1) : number))));
        }
        this.tagRendererContext.onSoftRebuildRequested().accept(map);
        this.tagRendererContext.onMainTagEdited().run();
    }

    private List<Integer> getNumberList() {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int i = 0; i < ((CollectionTag)this.getTag()).size(); ++i) {
            numbers.add(i + 1);
        }
        return numbers;
    }

    public static final class ByteArrayTagRenderer
    extends CollectionTagRenderer<ByteArrayTag> {
        public ByteArrayTagRenderer(String tagName, ByteArrayTag tag, TagRendererContext<ByteArrayTag> ctx) {
            super(tagName, tag, ctx, NumericTagRenderer.BYTE_COLOR, ByteTag.TYPE);
        }
    }

    public static final class LongArrayTagRenderer
    extends CollectionTagRenderer<LongArrayTag> {
        public LongArrayTagRenderer(String tagName, LongArrayTag tag, TagRendererContext<LongArrayTag> ctx) {
            super(tagName, tag, ctx, NumericTagRenderer.LONG_COLOR, LongTag.TYPE);
        }
    }

    public static final class IntArrayTagRenderer
    extends CollectionTagRenderer<IntArrayTag> {
        public IntArrayTagRenderer(String tagName, IntArrayTag tag, TagRendererContext<IntArrayTag> ctx) {
            super(tagName, tag, ctx, NumericTagRenderer.INT_COLOR, IntTag.TYPE);
        }
    }

    public static final class ListTagRenderer
    extends CollectionTagRenderer<ListTag> {
        public ListTagRenderer(String tagName, ListTag tag, TagRendererContext<ListTag> ctx) {
            super(tagName, tag, ctx, ARGB.color((int)255, (int)245, (int)172, (int)47), TagTypes.getRegisteredTags());
        }
    }
}

