/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.propertiesWidget.renderers;

import java.util.function.Consumer;
import net.blockomorph.screens.morphConfig.propertiesWidget.PropertyRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ObjectListRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class UnknownPropertyRenderer<T extends Comparable<T>>
implements PropertyRenderer<T, Property<T>> {
    private final ObjectListRenderer<Property<T>, T> RENDERER = new ObjectListRenderer<Property, Comparable>(-1, -256, 7, Property::getName, Property::getPossibleValues);
    private boolean notClose;

    @Override
    public void renderBackground(GuiUtils gui, Property<T> property, T value, Rect2i box) {
        this.renderPlate(gui, box, 3);
        this.RENDERER.renderName(gui, box.getX() + 41, box.getY() + 6, 20, property, value, -1);
    }

    @Override
    public void render(GuiUtils gui, Property<T> property, T value, Rect2i box) {
        if (this.RENDERER.isCurrentProperty(property)) {
            this.RENDERER.render(gui, box.getX() + 41, box.getY() + 6, -1, 8);
        }
    }

    @Override
    public boolean mouseClicked(Consumer<BlockState> newStateHandler, BlockState state, Property<T> property, T t, double mouseX, double mouseY, Rect2i box) {
        if (this.RENDERER.isCurrentProperty(property) && this.RENDERER.mouseClicked(mouseX, mouseY)) {
            return true;
        }
        if (GuiUtils.isInBounds(box, mouseX, mouseY)) {
            this.RENDERER.drop(property, newValue -> {
                GuiUtils.playClickSound();
                BlockState newState = (BlockState)state.trySetValue(property, newValue);
                newStateHandler.accept(newState);
            });
            GuiUtils.playClickSound();
            this.notClose = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(Consumer<BlockState> newStateHandler, BlockState state, Property<T> property, T t, double mouseX, double mouseY, double yOffsetWheel, Rect2i box) {
        if (this.RENDERER.isCurrentProperty(property)) {
            return this.RENDERER.mouseScrolled(mouseX, mouseY, yOffsetWheel);
        }
        return false;
    }

    @Override
    public boolean renderTooltip(GuiUtils gui, Property<T> property, T value, Rect2i box) {
        PropertyRenderer.super.renderTooltip(gui, property, value, box);
        if (this.RENDERER.isListFocused(gui.getMouseX(), gui.getMouseY())) {
            return this.RENDERER.isCurrentProperty(property);
        }
        if (GuiUtils.isMouseOver(box.getX() + 36, box.getY(), box.getX() + box.getWidth(), box.getY() + box.getHeight(), gui.getMouseX(), gui.getMouseY())) {
            String name = property.getName(value);
            if (gui.getFont().width(name) > 20) {
                gui.renderTooltip((Component)Component.literal((String)name), gui.getMouseX(), gui.getMouseY());
            }
        }
        return false;
    }

    @Override
    public void startClick() {
        this.notClose = false;
    }

    @Override
    public void endClick() {
        if (!this.notClose) {
            this.RENDERER.close();
        }
    }
}

