/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.world.phys.AABB;

public class DynamicSizeItemStackRenderState
extends TrackingItemStackRenderState {
    private final AABB aabb;
    private final float sizeMultiplier;

    public DynamicSizeItemStackRenderState(float scale) {
        float size2 = scale / 2.0f;
        this.aabb = new AABB((double)(-size2), (double)(-size2), 0.0, (double)size2, (double)size2, 0.0);
        this.sizeMultiplier = scale / 16.0f;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        poseStack.scale(this.sizeMultiplier, this.sizeMultiplier, this.sizeMultiplier);
        super.render(poseStack, multiBufferSource, light, overlay);
    }

    public boolean isOversizedInGui() {
        return true;
    }

    public AABB getModelBoundingBox() {
        return this.aabb;
    }
}

