/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.blockomorph.screens.utils.GuiBlockRenderState;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.blockomorph.utils.accessors.LightningSetter;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class GuiBlockRenderer
extends PictureInPictureRenderer<GuiBlockRenderState> {
    public GuiBlockRenderer(MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
    }

    public Class<GuiBlockRenderState> getRenderStateClass() {
        return GuiBlockRenderState.class;
    }

    protected void renderToTexture(GuiBlockRenderState guiState, PoseStack stack) {
        LightningSetter.renderWithLight(() -> {
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(30.0f));
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
            stack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            BlockEntity blockEntity = guiState.getBlockEntity();
            this.renderBlock(stack, guiState.getState(), blockEntity != null ? blockEntity.getBlockPos() : GuiUtils.AIR);
            this.renderBlockEntity(guiState.getDeltaTick(), stack, blockEntity);
        }, GuiUtils.DIFFUSE_LIGHT_START, GuiUtils.DIFFUSE_LIGHT_END);
    }

    protected void blitTexture(GuiBlockRenderState pictureInPictureRenderState, GuiRenderState guiRenderState) {
        super.blitTexture((PictureInPictureRenderState)pictureInPictureRenderState, guiRenderState);
        LightningSetter.disableLigth();
    }

    private void renderBlock(PoseStack stack, BlockState blockState, BlockPos pos) {
        RandomSource random = RandomSource.create((long)blockState.getSeed(pos));
        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
            List list = GuiUtils.blockRenderer.getBlockModel(blockState).collectParts(random);
            RenderType renderType = ItemBlockRenderTypes.getMovingBlockRenderType((BlockState)blockState);
            ClientLevelAccessor acc = ClientLevelAccessor.of((Level)GuiUtils.MC.level);
            acc.setSpecialRenderingMode(true);
            GuiUtils.blockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)GuiUtils.MC.level, list, blockState, pos, stack, this.bufferSource.getBuffer(renderType), false, OverlayTexture.NO_OVERLAY);
            acc.setSpecialRenderingMode(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BlockEntity> void renderBlockEntity(float delta, PoseStack stack, T blockEntity) {
        BlockEntityRenderer renderer;
        if (blockEntity != null && (renderer = GuiUtils.blockEntityRenderer.getRenderer(blockEntity)) != null) {
            ClientLevelAccessor acc = ClientLevelAccessor.of((Level)GuiUtils.MC.level);
            try {
                Camera cam = Minecraft.getInstance().getBlockEntityRenderDispatcher().camera;
                acc.setSpecialRenderingMode(true);
                renderer.render(blockEntity, delta, stack, (MultiBufferSource)this.bufferSource, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY, cam.getPosition());
            }
            catch (Exception exception) {
            }
            finally {
                acc.setSpecialRenderingMode(false);
            }
        }
    }

    protected float getTranslateY(int length, int height) {
        return (float)length / 2.0f;
    }

    protected String getTextureLabel() {
        return MorphUtils.res("block and blockentity").toString();
    }
}

