/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import net.blockomorph.screens.overlay.BlockHeartOverlay;
import net.blockomorph.screens.overlay.Overlay;
import net.blockomorph.screens.overlay.PlayerCrackOverlay;
import net.blockomorph.screens.utils.DynamicSizeItemStackRenderState;
import net.blockomorph.screens.utils.GuiBlockRenderState;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.accessors.GuiAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GuiUtils {
    public static final BlockPos AIR = new BlockPos(0, 500, 0);
    public static final Minecraft MC = Minecraft.getInstance();
    public static final List<Overlay> OVERLAYS = new ArrayList<Overlay>();
    public static final BlockRenderDispatcher blockRenderer = MC.getBlockRenderer();
    public static final BlockEntityRenderDispatcher blockEntityRenderer = MC.getBlockEntityRenderDispatcher();
    public static final Vector3f DIFFUSE_LIGHT_START;
    public static final Vector3f DIFFUSE_LIGHT_END;
    private GuiGraphics GUI;
    private GuiRenderState guiRenderState;
    private int mouseX;
    private int mouseY;
    private float tick;
    private Font font;

    public static ResourceLocation res(String path) {
        return MorphUtils.res(path);
    }

    public static ResourceLocation vanillaRes(String path) {
        return MorphUtils.vanillaRes(path);
    }

    public void setGuiGraphics(GuiGraphics gui, Font font, int mouseX, int mouseY, float tick) {
        this.GUI = gui;
        this.guiRenderState = GuiAccessor.extractStateFrom(gui);
        this.font = font;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.tick = tick;
    }

    public GuiGraphics getGuiGraphics() {
        return this.GUI;
    }

    public Font getFont() {
        return this.font;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public float getTick() {
        return this.tick;
    }

    public void blit(ResourceLocation resourceLocation, int x, int y, float u, float v, int uvMaxX, int uvMaxY, int maxX, int maxY) {
        this.GUI.blit(RenderPipelines.GUI_TEXTURED, resourceLocation, x, y, u, v, uvMaxX, uvMaxY, maxX, maxY);
    }

    public void blitMonoImage(ResourceLocation resourceLocation, int x, int y, int maxSizeX, int maxSizeY) {
        this.blit(resourceLocation, x, y, 0.0f, 0.0f, maxSizeX, maxSizeY, maxSizeX, maxSizeY);
    }

    public void renderTooltip(Component text, int mouseX, int mouseY) {
        this.renderTooltip(List.of(text), mouseX, mouseY);
    }

    public void renderTooltip(List<Component> texts, int mouseX, int mouseY) {
        this.GUI.setComponentTooltipForNextFrame(this.font, texts, mouseX, mouseY);
    }

    public void renderSprite(ResourceLocation resourceLocation, int x, int y, int maxSizeX, int maxSizeY) {
        this.GUI.blitSprite(RenderPipelines.GUI_TEXTURED, resourceLocation, x, y, maxSizeX, maxSizeY);
    }

    public void renderFromSpriteClass(TextureAtlasSprite sprite, int x, int y, int maxSizeX, int maxSizeY, int color) {
        this.GUI.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, x, y, maxSizeX, maxSizeY, color);
    }

    public void drawString(Component text, int x, int y, int color, boolean useShadow) {
        if (ARGB.alpha((int)color) == 0) {
            color = 0xFF000000 | color;
        }
        this.GUI.drawString(this.font, text, x, y, color, useShadow);
    }

    public void drawCenteredString(Component text, int xCenter, int y, int color, boolean useShadow) {
        int x = xCenter - this.font.width(text.getString()) / 2;
        this.drawString(text, x, y, color, useShadow);
    }

    public void drawCenteredStringWithAdditional(Component text, int xCenter, int y, int color, boolean useShadow, BiConsumer<Integer, Integer> additional) {
        int length = this.font.width(text.getString());
        int x = xCenter - length / 2;
        additional.accept(x, length);
        this.drawString(text, x, y, color, useShadow);
    }

    public void fill(int x, int y, int endX, int endY, int color) {
        this.GUI.fill(x, y, endX, endY, color);
    }

    public void blurScreen(int width, int height, int alpha) {
        this.fill(0, 0, width, height, ARGB.color((int)alpha, (int)77, (int)77, (int)77));
    }

    public void enableScrissors(int x, int y, int endX, int endY) {
        this.GUI.enableScissor(x, y, endX, endY);
    }

    public void disableScrissors() {
        this.GUI.disableScissor();
    }

    public void renderItem(ItemStack item, float x, float y, float scale, float ignored) {
        if (scale == 1.0f) {
            scale = 16.0f;
        }
        DynamicSizeItemStackRenderState trackingItemStackRenderState = new DynamicSizeItemStackRenderState(scale);
        MC.getItemModelResolver().updateForTopItem((ItemStackRenderState)trackingItemStackRenderState, item, ItemDisplayContext.GUI, (Level)GuiUtils.MC.level, (LivingEntity)GuiUtils.MC.player, 0);
        this.guiRenderState.submitItem(new GuiItemRenderState(item.getItem().getName().toString(), new Matrix3x2f((Matrix3x2fc)this.GUI.pose()), (TrackingItemStackRenderState)trackingItemStackRenderState, (int)x, (int)y, this.GUI.peekScissorStack()));
    }

    public void renderInDepthIfNeededAfterBlockRendering(Runnable rendering) {
        rendering.run();
    }

    public static void renderOverlay(GuiGraphics gui, float delta) {
        GuiUtils guiUtils = new GuiUtils();
        guiUtils.setGuiGraphics(gui, GuiUtils.MC.font, -100, -100, delta);
        Window window = Minecraft.getInstance().getWindow();
        if (GuiUtils.MC.level != null) {
            OVERLAYS.forEach(overlay -> overlay.render(guiUtils, window.getGuiScaledWidth(), window.getGuiScaledHeight()));
        }
    }

    public void renderBlockInGui(BlockState blockState, @Nullable BlockEntity blockEntity, float x, float y, float scale) {
        this.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new GuiBlockRenderState(blockState, blockEntity, (int)x, (int)y, scale, this.tick, this.GUI.peekScissorStack()));
    }

    public void renderAdditionalOnBlock(BlockState blockState, float x, float y, float scale) {
        if (blockState.getRenderShape() == RenderShape.INVISIBLE) {
            Item item = null;
            if (blockState.getBlock() instanceof LiquidBlock) {
                item = blockState.getFluidState().getType().getBucket();
            } else if (blockState.getBlock().asItem() != Items.AIR) {
                item = blockState.getBlock().asItem();
            }
            if (item != null) {
                ItemStack itemStack = new ItemStack((ItemLike)item);
                HashMap<String, String> map = new HashMap<String, String>();
                for (Property property : blockState.getProperties()) {
                    map.put(property.getName(), blockState.getValue(property).toString());
                }
                itemStack.set(DataComponents.BLOCK_STATE, (Object)new BlockItemStateProperties(map));
                this.renderItem(itemStack, x, y, scale, 100.0f);
            }
        }
    }

    public static boolean isMouseOver(int x, int y, int endX, int endY, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)endX && mouseY >= (double)y && mouseY < (double)endY;
    }

    public static boolean isInBounds(Rect2i box, double mouseX, double mouseY) {
        return GuiUtils.isMouseOver(box.getX(), box.getY(), box.getX() + box.getWidth(), box.getY() + box.getHeight(), mouseX, mouseY);
    }

    public static void playClickSound() {
        MC.getSoundManager().play(GuiUtils.getClickSound());
    }

    public static SoundInstance getClickSound() {
        return SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f);
    }

    public static void pushHotbarMessage(Component text) {
        GuiUtils.MC.gui.setOverlayMessage(text, false);
        MC.getNarrator().saySystemNow(text);
    }

    static {
        Matrix4f matrix4f = new Matrix4f().scaling(1.0f, -1.0f, 1.0f).rotateYXZ(1.0821041f, 3.2375858f, 0.0f).rotateYXZ(-2.41661f, 2.3561945f, 0.0f);
        DIFFUSE_LIGHT_START = matrix4f.transformDirection((Vector3fc)new Vector3f(0.2f, 1.0f, -0.7f).normalize(), new Vector3f());
        DIFFUSE_LIGHT_END = matrix4f.transformDirection((Vector3fc)new Vector3f(-0.2f, 1.0f, 0.7f).normalize(), new Vector3f());
        OVERLAYS.add(new PlayerCrackOverlay());
        OVERLAYS.add(new BlockHeartOverlay());
    }
}

