/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import net.blockomorph.screens.utils.FogLiquidModifier;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FogType;
import org.jetbrains.annotations.Nullable;

public class ModLiquidFogEnvironment
extends FogEnvironment {
    private final FogLiquidModifier MODIFIER = new FogLiquidModifier();
    private FogLiquidModifier.LiquidFogData cachedFog;

    public void setupFog(FogData fogData, Entity entity, BlockPos blockPos, ClientLevel clientLevel, float f, DeltaTracker deltaTracker) {
        if (this.cachedFog != null) {
            fogData.environmentalStart = this.cachedFog.start();
            fogData.environmentalEnd = this.cachedFog.end();
            fogData.skyEnd = this.cachedFog.end();
            fogData.cloudEnd = this.cachedFog.end();
        }
        this.cachedFog = null;
    }

    public int getBaseColor(ClientLevel clientLevel, Camera camera, int i, float f) {
        if (this.cachedFog != null) {
            return this.cachedFog.color();
        }
        return -1;
    }

    public boolean isApplicable(@Nullable FogType fogType, Entity entity) {
        if (this.cachedFog != null) {
            return true;
        }
        Level level = entity.level();
        if (level instanceof ClientLevel) {
            ClientLevel lv = (ClientLevel)level;
            this.cachedFog = this.MODIFIER.getFog(lv.entitiesForRendering(), false);
        }
        return this.cachedFog != null;
    }

    public void onNotApplicable() {
        this.cachedFog = null;
    }
}

