/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.blockomorph.network.ClientBoundMorphUpdatePacket;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.MorphedBlockEntityProblemReporter;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class BlockInPlayer2 {
    private final InPlayerBlockPos offset;
    private final BlockPos pos;
    private final Player player;
    private BlockState blockState;
    private BlockEntity blockEntity;
    private BlockEntityTicker blockEntityTicker;
    private ModelData data = ModelData.EMPTY;

    public BlockInPlayer2(PlayerAccessor pl, InPlayerBlockPos pos, BlockState state, Consumer<BlockInPlayer2> preInit) {
        this.offset = pos;
        this.pos = pos.boundedBlockPos(pl.player());
        if (this.pos == null) {
            throw new IllegalArgumentException("Null BlockPos in BlockInPlayer! Player section: " + String.valueOf(BlockPosBounds.getChunkPosForPlayer(pl.player())) + " Level: " + String.valueOf(pl.player().level()));
        }
        this.player = pl.player();
        this.blockState = state;
        preInit.accept(this);
        this.initBlockEntity();
        this.initTicker();
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public InPlayerBlockPos getOffset() {
        return this.offset;
    }

    protected boolean shouldShowFluidState() {
        return Config.getInstance().getValue("liquidsInBlocks", Boolean.class);
    }

    public boolean shouldDoFluidAction() {
        return this.blockState.getBlock() instanceof LiquidBlock || !this.blockState.getFluidState().isEmpty() && this.shouldShowFluidState();
    }

    @Nullable
    public List<String> loadNBT(CompoundTag tg) {
        if (this.blockEntity != null) {
            try {
                MorphedBlockEntityProblemReporter collector = new MorphedBlockEntityProblemReporter(25, 200);
                ValueInput valueInput = TagValueInput.create((ProblemReporter)collector, (HolderLookup.Provider)this.player.level().registryAccess(), (CompoundTag)tg);
                this.blockEntity.loadWithComponents(valueInput);
                return collector.getProblemsIfNotEmpty();
            }
            catch (Throwable e) {
                return List.of(Objects.requireNonNullElse(e.getMessage(), e.getClass().getName()));
            }
        }
        return null;
    }

    public BlockInPlayer2 handleClientTag(CompoundTag tg, ClientBoundMorphUpdatePacket pkt) {
        if (this.blockEntity != null) {
            try {
                ClientboundBlockEntityDataPacket.create((BlockEntity)this.blockEntity, (ent, access) -> tg).handle((ClientGamePacketListener)pkt.getListener());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public void onPlace(BlockState newState, BlockState oldState, int flags) {
        if (!this.player.level().isClientSide) {
            newState.onPlace(this.player.level(), this.pos, oldState, (flags & 0x40) != 0);
        }
    }

    public BlockInPlayer2 changeBlockState(BlockState state, int flags) {
        boolean bl5;
        BlockState old = this.blockState;
        this.blockState = state;
        boolean newBlock = !old.is(state.getBlock());
        boolean bl4 = (flags & 0x40) != 0;
        boolean bl = bl5 = (flags & 0x100) == 0;
        if (newBlock && old.hasBlockEntity()) {
            if (!this.player.level().isClientSide && bl5 && this.blockEntity != null) {
                this.blockEntity.preRemoveSideEffects(this.pos, old);
            }
            this.clearBlockEntity();
        }
        if (newBlock || state.getBlock() instanceof BaseRailBlock) {
            this.checkUpdates(flags, old);
        }
        if (!this.player.level().isClientSide && (flags & 0x200) == 0) {
            this.onPlace(state, old, flags);
        }
        if (state.hasBlockEntity()) {
            if (this.blockEntity == null) {
                this.initBlockEntity();
            } else {
                this.blockEntity.setBlockState(state);
            }
        }
        this.initTicker();
        return this;
    }

    public void checkUpdates(int flags, BlockState old) {
        Level level = this.player.level();
        if (level instanceof ServerLevel) {
            boolean bl4;
            ServerLevel serverLevel = (ServerLevel)level;
            boolean bl = bl4 = (flags & 0x40) != 0;
            if ((flags & 1) != 0 || bl4) {
                old.affectNeighborsAfterRemoval(serverLevel, this.pos, bl4);
            }
        }
    }

    public void clearBlockEntity() {
        this.blockEntity = null;
        this.blockEntityTicker = null;
    }

    private void initBlockEntity() {
        Block block = this.blockState.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock ent = (EntityBlock)block;
            this.blockEntity = ent.newBlockEntity(this.pos, this.blockState);
            if (this.blockEntity != null) {
                this.blockEntity.setLevel(this.player.level());
                this.blockEntity.onLoad();
            }
        }
    }

    private void initTicker() {
        Block block = this.blockState.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock ent = (EntityBlock)block;
            if (this.blockEntity != null) {
                this.blockEntityTicker = ent.getTicker(this.player.level(), this.blockState, this.blockEntity.getType());
            }
        }
    }

    public void connectModelData(ModelData data) {
        this.data = Objects.requireNonNullElse(data, ModelData.EMPTY);
    }

    public ModelData getModelData() {
        return this.data;
    }

    public void tick() {
        if (this.blockEntity != null && this.blockEntityTicker != null) {
            try {
                this.blockEntityTicker.tick(this.player.level(), this.pos, this.blockState, this.blockEntity);
            }
            catch (Exception e) {
                this.blockEntityTicker = null;
                MorphUtils.LOGGER.error("An unexpected exception occurred while ticking a block entity in a transformed player with username " + this.player.getName().getString() + ": ", (Throwable)e);
            }
        }
    }

    public void animateTick(RandomSource randomSource, Block marker, Consumer<BlockState> needSpawnFluidDrip) {
        FluidState fluidState;
        if (this.player.level().isClientSide) {
            this.blockState.getBlock().animateTick(this.blockState, this.player.level(), this.pos, randomSource);
        }
        if (this.shouldDoFluidAction() && !(fluidState = this.blockState.getFluidState()).isEmpty()) {
            fluidState.animateTick(this.player.level(), this.pos, randomSource);
            needSpawnFluidDrip.accept(PlayerAccessor.of(this.player).getBlockState(this.offset.offset(0, -1, 0)));
        }
        if (this.blockState.getBlock() == marker) {
            Vec3 real = MorphUtils.getCetneredRealBlockPos(PlayerAccessor.of(this.player), this.offset);
            this.player.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_MARKER, this.blockState), real.x, real.y, real.z, 0.0, 0.0, 0.0);
        }
    }
}

