/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.concurrent.atomic.AtomicReference;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.EntityAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.dataSyncher.TagSyncedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ChairController {
    private final Entity owner;
    private final TagSyncedData CHAIR_DATA;
    private BlockState chairBlockstate;
    private InPlayerBlockPos realPos;

    public ChairController(Entity owner) {
        this.owner = owner;
        this.CHAIR_DATA = new TagSyncedData(owner, MorphUtils.res("chair_data"), new CompoundTag(), this::onDataReceived);
    }

    public CompoundTag getTagData() {
        return (CompoundTag)this.CHAIR_DATA.get();
    }

    public void tick() {
        Entity entity;
        if (!this.owner.level().isClientSide && (entity = this.owner.getVehicle()) instanceof PlayerAccessor) {
            BlockState state;
            PlayerAccessor pl = (PlayerAccessor)entity;
            if (!((CompoundTag)this.CHAIR_DATA.get()).isEmpty() && (state = this.chairBlockstate) != null && !pl.getBlockState(this.realPos).getBlock().equals(state.getBlock())) {
                this.owner.stopRiding();
            }
        }
    }

    public void onStopRiding() {
        if (!this.owner.level().isClientSide) {
            Entity entity = this.owner.getVehicle();
            if (entity instanceof PlayerAccessor) {
                BlockState state2;
                BlockState state;
                PlayerAccessor pl = (PlayerAccessor)entity;
                if (!((CompoundTag)this.CHAIR_DATA.get()).isEmpty() && (state = this.chairBlockstate) != null && !state.equals((Object)(state2 = this.findOccupied(state)))) {
                    pl.setBlockState(this.realPos, state2, 3);
                }
            }
            this.CHAIR_DATA.set(new CompoundTag());
        }
    }

    public Entity replaceEntityOnMorphedPlayer(Entity entity) {
        AtomicReference<Entity> chair = new AtomicReference<Entity>(entity);
        Vec3 pos = EntityAccessor.of(entity).getMorphedPos();
        if (pos != null && this.isChair(entity)) {
            InPlayerBlockPos.check(BlockPos.containing((Position)pos), (pl, realPos) -> {
                chair.set((Entity)pl.player());
                CompoundTag tg = new CompoundTag();
                entity.setPos(0.0, pos.y, 0.0);
                Vec3 vec3 = entity.getPassengerRidingPosition(this.owner);
                Vec3 vec32 = this.owner.getVehicleAttachmentPoint(entity);
                tg.putDouble("x", pos.x);
                tg.putDouble("y", vec3.y - vec32.y);
                tg.putDouble("z", pos.z);
                tg.put("Chair", (Tag)NbtUtils.writeBlockState((BlockState)pl.getBlockState((InPlayerBlockPos)realPos)));
                tg.putString("RealPos", realPos.string());
                this.CHAIR_DATA.set(tg);
                entity.discard();
            }, null, (LevelReader)this.owner.level());
        }
        return chair.get();
    }

    private boolean isChair(Entity ent) {
        Mob mob;
        return ent.noPhysics || ent instanceof Mob && (mob = (Mob)ent).isNoAi() || !ent.shouldRender(ent.getX(), ent.getY(), ent.getZ());
    }

    private BlockState findOccupied(BlockState state) {
        for (Property prop : state.getProperties()) {
            BooleanProperty bProp;
            if (!(prop instanceof BooleanProperty) || !(bProp = (BooleanProperty)prop).getName().equalsIgnoreCase("occupied")) continue;
            return (BlockState)state.setValue((Property)bProp, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public void onDataReceived() {
        CompoundTag tg = (CompoundTag)this.CHAIR_DATA.get();
        if (tg.isEmpty()) {
            this.chairBlockstate = null;
            this.realPos = null;
        } else {
            this.chairBlockstate = NbtUtils.readBlockState((HolderGetter)this.owner.level().holderLookup(Registries.BLOCK), (CompoundTag)tg.getCompound("Chair").orElseGet(CompoundTag::new));
            this.realPos = InPlayerBlockPos.parseBlockPos(tg.getString("RealPos").orElse("0 64 0"));
        }
    }
}

