/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.DataResult;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.blockomorph.command.BlockmorphCommand;
import net.blockomorph.command.BlockmorphconfigCommand;
import net.blockomorph.core.KeyMappings;
import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.network.ClientBoundConfigUpdatePacket;
import net.blockomorph.network.MainPacket;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TriState;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDrownEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.function.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber
public class MorphUtils {
    public static final ResourceKey<DamageType> PLAYER_DESTROYED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)MorphUtils.res("player_destroyed"));
    public static final ResourceKey<DamageType> PLAYER_DESTROYED_NULL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)MorphUtils.res("player_destroyed_null"));
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"blockomorph");
    private static final HashMap<ResourceLocation, PacketInfo> handlers = new HashMap();

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static ResourceLocation res(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"blockomorph", (String)path);
    }

    public static ResourceLocation vanillaRes(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static PacketInfo getHandler(ResourceLocation id) {
        return handlers.get(id);
    }

    public static void sendServer(BlockMorphPacket packet) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new MainPacket(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendAll(BlockMorphPacket packet) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new MainPacket(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendPlayer(BlockMorphPacket packet, ServerPlayer pl) {
        PacketDistributor.sendToPlayer((ServerPlayer)pl, (CustomPacketPayload)new MainPacket(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void registerPacket(String id, Function<FriendlyByteBuf, BlockMorphPacket> bl, boolean client) {
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"blockomorph", (String)id);
        if (handlers.containsKey(res)) {
            throw new IllegalArgumentException("Packet with Id: " + id + " alredy registered!");
        }
        handlers.put(ResourceLocation.fromNamespaceAndPath((String)"blockomorph", (String)id), new PacketInfo(bl, client));
    }

    public static void doBlockInMorphedPlayerOnPos(@Nullable Entity self, Iterable<Entity> entities, Vec3 pos, BiConsumer<PlayerAccessor, BlockInPlayer2> action) {
        for (Entity entity : entities) {
            PlayerAccessor pl;
            if (entity == self || !(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive() || !entity.getBoundingBox().contains(pos)) continue;
            pl.getBlocksData2InArea(new AABB(pos, pos), (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(blockOffset, block, realPos) -> action.accept(pl, (BlockInPlayer2)block)));
        }
    }

    public static boolean needModedHit(Predicate<Class<?>> predicate) {
        Optional findedClazz;
        if (Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).projectile && (findedClazz = STACK_WALKER.walk(stackFrameStream -> stackFrameStream.skip(1L).filter(frame -> predicate.test(frame.getDeclaringClass())).findFirst().map(StackWalker.StackFrame::getDeclaringClass))).isPresent()) {
            return !Projectile.class.isAssignableFrom((Class)findedClazz.get());
        }
        return true;
    }

    public static Predicate<String> blockPredicate() {
        return value -> {
            DataResult result = ResourceLocation.read((String)value);
            if (result.result().isPresent()) {
                return BuiltInRegistries.BLOCK.containsKey((ResourceLocation)result.result().get());
            }
            return false;
        };
    }

    @SubscribeEvent
    public static void run(ServerStartingEvent event) {
        Config.setServer(event.getServer());
        BlockPosBounds.load();
    }

    @SubscribeEvent
    public static void commandRegister(RegisterCommandsEvent event) {
        BlockmorphconfigCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        BlockmorphCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        KeyMappings.registerKeyMappings(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MorphUtils.sendPlayer(new ClientBoundConfigUpdatePacket(Config.getInstance()), player);
        PlayerAccessor.of((Player)player).sendAllContentToPlayer(player);
    }

    public static Vec3 getRealBlockPos(PlayerAccessor original, InPlayerBlockPos offset) {
        return MorphUtils.getRealBlockPos(original, new Vec3((double)offset.x, (double)offset.y, (double)offset.z));
    }

    public static Vec3 getRealBlockPos(PlayerAccessor original, Vec3 offset) {
        AABB aabb = original.player().getBoundingBox();
        InPlayerBlockPos minPos = original.minPos();
        double deltaX = offset.x - (double)minPos.getX();
        double deltaY = offset.y - (double)minPos.getY();
        double deltaZ = offset.z - (double)minPos.getZ();
        double globalX = aabb.minX + deltaX;
        double globalY = aabb.minY + deltaY;
        double globalZ = aabb.minZ + deltaZ;
        return new Vec3(globalX, globalY, globalZ);
    }

    public static void distanceTo(Vec3 from, Vec3 to, boolean sqr, double offset, DoubleConsumer action) {
        if (InPlayerBlockPos.isMorphedPlayerX(from.x) || InPlayerBlockPos.isMorphedPlayerX(to.x) && action != null) {
            from = InPlayerBlockPos.checkOnReal(from);
            to = InPlayerBlockPos.checkOnReal(to);
            double d0 = from.x + offset - to.x;
            double d1 = from.y + offset - to.y;
            double d2 = from.z + offset - to.z;
            double result = d0 * d0 + d1 * d1 + d2 * d2;
            if (!sqr) {
                result = Math.sqrt(result);
            }
            action.accept(result);
        }
    }

    public static void executeMorphedBlockShapeUpdate(LevelAccessor levelAccessor, Direction direction, BlockPos blockPos, BlockPos blockPos2, BlockState blockState, int i, int j, BlockState external) {
        if ((i & 0x80) == 0 || !external.is(Blocks.REDSTONE_WIRE)) {
            BlockState blockState3 = external.updateShape((LevelReader)levelAccessor, (ScheduledTickAccess)levelAccessor, blockPos, direction, blockPos2, blockState, levelAccessor.getRandom());
            Block.updateOrDestroy((BlockState)external, (BlockState)blockState3, (LevelAccessor)levelAccessor, (BlockPos)blockPos, (int)i, (int)j);
        }
    }

    public static Vec3 getCetneredRealBlockPos(PlayerAccessor original, InPlayerBlockPos offset) {
        Vec3 vec = MorphUtils.getRealBlockPos(original, offset);
        return new Vec3(vec.x + 0.5, vec.y + 0.5, vec.z + 0.5);
    }

    public static boolean isAdventureCanBreak(PlayerAccessor pl, Player attacker, InPlayerBlockPos hitPart) {
        BlockInPlayer2 block = pl.getBlocksData2().get(hitPart);
        if (block != null) {
            BlockInWorld blockinworld = new BlockInWorld((LevelReader)pl.player().level(), block.getPos(), true);
            ItemStack itemstack = attacker.getMainHandItem();
            return !itemstack.isEmpty() && (itemstack.canBreakBlockInAdventureMode(blockinworld) || itemstack.canPlaceOnBlockInAdventureMode(blockinworld));
        }
        return false;
    }

    public static boolean needRejectUse(Level lv, BlockHitResult block) {
        if (InPlayerBlockPos.isMorphedPlayerX(block.getBlockPos().getX())) {
            BlockState state = lv.getBlockState(block.getBlockPos());
            Config.UseMode mode = Config.getInstance().getValue("useMode", Config.UseMode.class);
            switch (mode) {
                case DISABLED: {
                    return true;
                }
                case VANILLA: {
                    ResourceLocation res = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                    return !res.getNamespace().equals("minecraft");
                }
            }
        }
        return false;
    }

    public static UseOnContext checkOnRealIfOut(UseOnContext ctx, ItemStack stack) {
        Config.PlaceMode mode;
        if (stack.getItem() instanceof BlockItem && InPlayerBlockPos.isMorphedPlayerX(ctx.getClickedPos().getX()) && (mode = Config.getInstance().getValue("placeMode", Config.PlaceMode.class)) == Config.PlaceMode.OUT) {
            Vec3 realHit = InPlayerBlockPos.checkOnReal(ctx.getClickLocation());
            realHit = MorphUtils.toDirection(realHit, ctx.getClickedFace());
            BlockHitResult hit = new BlockHitResult(realHit, ctx.getClickedFace(), BlockPos.containing((Position)realHit), ctx.isInside());
            return new UseOnContext(ctx.getLevel(), ctx.getPlayer(), ctx.getHand(), ctx.getItemInHand(), hit);
        }
        return ctx;
    }

    private static Vec3 toDirection(Vec3 vec, Direction dir) {
        Vec3i step = dir.getUnitVec3i();
        double x = switch (step.getX()) {
            case 1 -> Math.ceil(vec.x) + 1.0E-7;
            case -1 -> Math.floor(vec.x) - 1.0E-7;
            default -> vec.x;
        };
        double y = switch (step.getY()) {
            case 1 -> Math.ceil(vec.y) + 1.0E-7;
            case -1 -> Math.floor(vec.y) - 1.0E-7;
            default -> vec.y;
        };
        double z = switch (step.getZ()) {
            case 1 -> Math.ceil(vec.z) + 1.0E-7;
            case -1 -> Math.floor(vec.z) - 1.0E-7;
            default -> vec.z;
        };
        return new Vec3(x, y, z);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Config.PlaceMode mode;
        if (event.getEntity().getItemInHand(event.getHand()).getItem() instanceof BlockItem && (mode = Config.getInstance().getValue("placeMode", Config.PlaceMode.class)) == Config.PlaceMode.DISABLED && InPlayerBlockPos.isMorphedPlayerX(event.getHitVec().getBlockPos().getX())) {
            event.setUseItem(TriState.FALSE);
        }
    }

    public static boolean canOpenConfig() {
        Minecraft mc = Minecraft.getInstance();
        return mc.player != null && mc.player.hasPermissions(2) && Config.getInstance().getValue("canOperatorModifyConfig", Boolean.class) != false;
    }

    public static Config.ScreenAccess getScreenAccess(Player player) {
        if (player != null && player.hasPermissions(2)) {
            return Config.ScreenAccess.ALL;
        }
        return Config.getInstance().getValue("screenAccess", Config.ScreenAccess.class);
    }

    public static boolean canOpenMenuIn(PlayerAccessor pl, InPlayerBlockPos offset) {
        BlockInPlayer2 block = pl.getBlocksData2().get(offset);
        if (block != null) {
            MenuProvider pr = block.getBlockState().getMenuProvider(pl.player().level(), block.getPos());
            return pr != null;
        }
        return false;
    }

    public static boolean onPlayerAttacked(DamageSource damage, Entity attacked) {
        if (attacked instanceof PlayerAccessor) {
            boolean allowed;
            PlayerAccessor pl = (PlayerAccessor)attacked;
            if (damage.getDirectEntity() instanceof Player ? Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand : damage.getDirectEntity() instanceof Projectile && Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).projectile) {
                return false;
            }
            boolean noTnt = pl.getTnt() == null;
            boolean tntBlock = pl.getBlockState(InPlayerBlockPos.ZERO).getBlock() instanceof TntBlock;
            boolean tntDamage = damage.is(DamageTypes.PLAYER_EXPLOSION) || damage.is(DamageTypes.EXPLOSION);
            boolean bl = allowed = damage.is(DamageTypes.GENERIC_KILL) || damage.is(DamageTypes.FELL_OUT_OF_WORLD);
            if (pl.isActive()) {
                if (allowed || !tntBlock && tntDamage) {
                    MorphUtils.destroy(pl, damage.getEntity());
                } else if (tntBlock && tntDamage && noTnt) {
                    pl.setTnt();
                    PrimedTnt tnt = pl.getTnt();
                    if (tnt != null) {
                        tnt.setFuse(tnt.getFuse() / 2);
                    }
                }
                return !damage.is(PLAYER_DESTROYED) && !damage.is(PLAYER_DESTROYED_NULL);
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerDrown(LivingDrownEvent event) {
        PlayerAccessor pl;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof PlayerAccessor && (pl = (PlayerAccessor)livingEntity).isActive()) {
            event.setDrowning(false);
        }
    }

    public static void destroy(PlayerAccessor mob_pl, @Nullable Entity attacker) {
        Player mob = (Player)mob_pl;
        Level level = mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel lv = (ServerLevel)level;
            Holder.Reference damage = mob.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(attacker == null ? PLAYER_DESTROYED_NULL : PLAYER_DESTROYED);
            mob.hurtServer(lv, new DamageSource((Holder)damage, attacker), Float.MAX_VALUE);
        }
    }

    public record PacketInfo(Function<FriendlyByteBuf, BlockMorphPacket> packet, boolean isClient) {
    }
}

