/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;

public class SavedBlock {
    private final BlockState blockstate;
    private final CompoundTag nbt;
    private final String key;

    public SavedBlock(BlockState state, CompoundTag nbt, String k) {
        this.blockstate = state;
        this.nbt = nbt;
        this.key = k;
    }

    public BlockState getState() {
        return this.blockstate;
    }

    public CompoundTag getTag() {
        return this.nbt;
    }

    public String getName() {
        return this.key;
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.blockstate));
        tag.put("Tag", (Tag)this.nbt);
        return tag;
    }

    public static SavedBlock fromTag(CompoundTag tag, String k) {
        CompoundTag nbt = tag.getCompound("Tag").orElse(new CompoundTag());
        BlockState state = NbtUtils.readBlockState((HolderGetter)Minecraft.getInstance().level.holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("BlockState").orElse(new CompoundTag()));
        return new SavedBlock(state, nbt, k);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SavedBlock) {
            SavedBlock e = (SavedBlock)obj;
            return e.getState().equals((Object)this.blockstate) && e.getTag().equals((Object)this.nbt) && e.getName().equals(this.key);
        }
        return false;
    }
}

