/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.coords;

import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class DummyLevelChunk
extends EmptyLevelChunk {
    private final Level level;

    public DummyLevelChunk(Level lv, ChunkPos boundedSection) {
        super(lv, boundedSection, (Holder)lv.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS));
        this.level = lv;
    }

    @Nullable
    public BlockState setBlockState(BlockPos pos, BlockState state, int flags) {
        CallbackInfoReturnable cir = new CallbackInfoReturnable("", true, (Object)Blocks.AIR.defaultBlockState());
        DummyLevelChunk.setBlockState(this.level, pos, state, flags, (CallbackInfoReturnable<BlockState>)cir);
        return (BlockState)cir.getReturnValue();
    }

    public BlockState getBlockState(BlockPos pos) {
        CallbackInfoReturnable cir = new CallbackInfoReturnable("", true, (Object)Blocks.AIR.defaultBlockState());
        DummyLevelChunk.getBlockState(this.level, pos, (CallbackInfoReturnable<BlockState>)cir);
        return (BlockState)cir.getReturnValue();
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos, LevelChunk.EntityCreationType p_62610_) {
        CallbackInfoReturnable cir = new CallbackInfoReturnable("", true, null);
        DummyLevelChunk.getBlockEntity(this.level, pos, (CallbackInfoReturnable<BlockEntity>)cir);
        return (BlockEntity)cir.getReturnValue();
    }

    public FluidState getFluidState(int x, int y, int z) {
        CallbackInfoReturnable cir = new CallbackInfoReturnable("", true, (Object)Fluids.EMPTY.defaultFluidState());
        DummyLevelChunk.getFluidState(this.level, new BlockPos(x, y, z), (CallbackInfoReturnable<FluidState>)cir);
        return (FluidState)cir.getReturnValue();
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getFluidState(pos.getX(), pos.getY(), pos.getZ());
    }

    public void removeBlockEntity(BlockPos pos) {
        DummyLevelChunk.removeBlockEntity(this.level, pos, new CallbackInfo("", true));
    }

    public FullChunkStatus getFullStatus() {
        return FullChunkStatus.BLOCK_TICKING;
    }

    public static void setBlockState(Level level, BlockPos pos, BlockState state, int flags, CallbackInfoReturnable<BlockState> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            cir.setReturnValue((Object)pl.getBlockState((InPlayerBlockPos)realPos));
            if (!pl.setBlockState((InPlayerBlockPos)realPos, state, flags)) {
                cir.setReturnValue(null);
            }
        }, null, (LevelReader)level);
    }

    public static void removeBlockEntity(Level level, BlockPos pos, CallbackInfo ci) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            ci.cancel();
            BlockInPlayer2 block = pl.getBlocksData2().get(realPos);
            if (block != null) {
                block.clearBlockEntity();
            }
        }, () -> ((CallbackInfo)ci).cancel(), (LevelReader)level);
    }

    public static void getBlockState(Level level, BlockPos pos, CallbackInfoReturnable<BlockState> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            ClientLevelAccessor acc;
            BlockState state = pl.getBlockState((InPlayerBlockPos)realPos);
            if (state == null) {
                cir.setReturnValue((Object)Blocks.AIR.defaultBlockState());
            } else if (level instanceof ClientLevelAccessor && (acc = (ClientLevelAccessor)level).isExternalMorphedBlockGetterLocked()) {
                cir.setReturnValue((Object)state);
            } else if (state.isAir() && !realPos.equals(InPlayerBlockPos.ZERO)) {
                Vec3 vec = MorphUtils.getCetneredRealBlockPos(pl, realPos);
                cir.setReturnValue((Object)level.getBlockState(BlockPos.containing((Position)vec)));
            } else {
                cir.setReturnValue((Object)state);
            }
        }, null, (LevelReader)level);
    }

    public static void getBlockEntity(Level level, BlockPos pos, CallbackInfoReturnable<BlockEntity> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> cir.setReturnValue((Object)pl.getBlockEntity((InPlayerBlockPos)realPos)), null, (LevelReader)level);
    }

    public static void getFluidState(Level level, BlockPos pos, CallbackInfoReturnable<FluidState> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            BlockState state = pl.getBlockState((InPlayerBlockPos)realPos);
            if (state == null || state.isAir() && !realPos.equals(InPlayerBlockPos.ZERO)) {
                Vec3 vec = MorphUtils.getCetneredRealBlockPos(pl, realPos);
                cir.setReturnValue((Object)level.getFluidState(BlockPos.containing((Position)vec)));
            } else {
                cir.setReturnValue((Object)state.getFluidState());
            }
        }, null, (LevelReader)level);
    }
}

