/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.coords;

import java.util.function.BiConsumer;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.PlayerMorphedSection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class InPlayerBlockPos {
    public static final int X_CHUNK_START = 60000000;
    public static final int X_CHUNK_END = 120000000;
    public static final int X_CENTER = 90000000;
    public static final int Y_CHUNK_START = 64;
    public static final InPlayerBlockPos ZERO = InPlayerBlockPos.get(0, 0, 0);
    public final int x;
    public final int y;
    public final int z;

    public static boolean isMorphedPlayerX(double x) {
        return x >= 6.0E7 && x <= 1.2E8;
    }

    public static boolean isMorphPlayerChunk(ChunkPos pos) {
        return pos.getMinBlockX() > 60000000 && pos.getMaxBlockX() < 120000000;
    }

    private InPlayerBlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isValid() {
        return this.x < 15 && this.x > -15 && this.z < 15 && this.z > -15 && this.y < 31 && this.y >= 0;
    }

    public InPlayerBlockPos offset(int x, int y, int z) {
        return InPlayerBlockPos.get(this.x + x, this.y + y, this.z + z);
    }

    public static Vec3 checkOnReal(Vec3 vec, @Nullable Vec3 detectionCoord) {
        PlayerMorphedSection pos;
        Player player;
        Vec3 detectingPos;
        Vec3 vec3 = detectingPos = detectionCoord == null ? vec : detectionCoord;
        if ((InPlayerBlockPos.isMorphedPlayerX(vec.x) || detectionCoord != null) && (player = BlockPosBounds.getPlayerByChunkPos(pos = BlockPosBounds.getPlayerSectionPos(BlockPos.containing((Position)detectingPos)), null)) != null) {
            double d0 = 0.5;
            double y = vec.y - 64.0;
            double x = vec.x - (double)(pos.x * 32) - 15.5 - 6.0E7 + d0;
            double z = vec.z - (double)(pos.z * 32) - 15.5 + d0;
            return MorphUtils.getRealBlockPos(PlayerAccessor.of(player), new Vec3(x, y, z));
        }
        return vec;
    }

    public static Vec3 checkOnReal(Vec3 vec) {
        return InPlayerBlockPos.checkOnReal(vec, null);
    }

    @Nullable
    public BlockPos boundedBlockPos(Player player) {
        PlayerMorphedSection pos;
        if (player != null && (pos = BlockPosBounds.getChunkPosForPlayer(player)) != null) {
            int y = 64 + this.y;
            int x = 60000000 + pos.x * 32 + this.x + 15;
            int z = pos.z * 32 + 15 + this.z;
            return new BlockPos(x, y, z);
        }
        return null;
    }

    public static AABB checkOnReal(AABB aabb) {
        if (aabb.minX > 6.0E7 || aabb.maxX > 6.0E7) {
            Vec3 center = aabb.getCenter();
            Vec3 min = InPlayerBlockPos.checkOnReal(new Vec3(aabb.minX, aabb.minY, aabb.minZ), center);
            Vec3 max = InPlayerBlockPos.checkOnReal(new Vec3(aabb.maxX, aabb.maxY, aabb.maxZ), center);
            return new AABB(min, max);
        }
        return aabb;
    }

    public static BlockPos checkOnReal(BlockPos pos) {
        return BlockPos.containing((Position)InPlayerBlockPos.checkOnReal(pos.getCenter()));
    }

    public static InPlayerBlockPos get(int x, int y, int z) {
        return new InPlayerBlockPos(x, y, z);
    }

    public static void check(BlockPos bounded, BiConsumer<PlayerAccessor, InPlayerBlockPos> action, Runnable elseRun, @Nullable Boolean lv) {
        if (bounded != null && action != null && InPlayerBlockPos.isMorphedPlayerX(bounded.getX())) {
            PlayerMorphedSection pos = BlockPosBounds.getPlayerSectionPos(bounded);
            Player player = BlockPosBounds.getPlayerByChunkPos(pos, lv);
            if (player != null) {
                int y = bounded.getY() - 64;
                int x = bounded.getX() - pos.x * 32 - 15 - 60000000;
                int z = bounded.getZ() - pos.z * 32 - 15;
                action.accept(PlayerAccessor.of(player), new InPlayerBlockPos(x, y, z));
            } else if (elseRun != null) {
                elseRun.run();
            }
        }
    }

    public static void check(BlockPos bounded, BiConsumer<PlayerAccessor, InPlayerBlockPos> action, Runnable elseRun, LevelReader lv) {
        InPlayerBlockPos.check(bounded, action, elseRun, lv.isClientSide());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InPlayerBlockPos) {
            InPlayerBlockPos bl = (InPlayerBlockPos)obj;
            return bl.x == this.x && bl.y == this.y && bl.z == this.z;
        }
        return false;
    }

    @Nullable
    public static InPlayerBlockPos parseBlockPos(String input) {
        String[] parts = input.trim().split(" ");
        if (parts.length != 3) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[0]);
            int y = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            return new InPlayerBlockPos(x, y, z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public FriendlyByteBuf write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.x);
        return buffer;
    }

    public InPlayerBlockPos(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public String string() {
        return this.x + " " + this.y + " " + this.z;
    }

    public String toString() {
        return "InPlayerBlockPos[x=" + this.x + " y=" + this.y + " z=" + this.z + "]";
    }

    public int hashCode() {
        return (this.x + this.y * 29) * 29 + this.z;
    }
}

