/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.tnt;

import javax.annotation.Nullable;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.EntityAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.dataSyncher.IntSyncedData;
import net.blockomorph.utils.tnt.TntSpawnLevel;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class TntHandler {
    private final IntSyncedData BRAKE_PROGRESS;
    private PrimedTnt tnt;
    private final Player player;
    private final PlayerAccessor pl;

    public TntHandler(PlayerAccessor owner) {
        this.player = (Player)owner;
        this.pl = owner;
        this.BRAKE_PROGRESS = new IntSyncedData((Entity)owner.player(), MorphUtils.res("tnt_progress"), -1, this::onClientUpdater);
    }

    public void onDimensionChange() {
        Entity tnt1 = this.tnt.getType().create(this.player.level(), EntitySpawnReason.DIMENSION_TRAVEL);
        if (tnt1 instanceof PrimedTnt) {
            PrimedTnt tnt2 = (PrimedTnt)tnt1;
            if (!this.player.level().isClientSide) {
                tnt2.restoreFrom((Entity)this.tnt);
                this.tnt = tnt2;
            }
        }
    }

    public void tick() {
        if (this.tnt != null) {
            if (!this.player.level().isClientSide && this.tnt.level() != this.player.level()) {
                this.onDimensionChange();
                return;
            }
            ProfilerFiller profiler = Profiler.get();
            profiler.push("morphedPlayerTntFuseTick");
            try {
                this.tnt.setPosRaw(this.player.getX(), this.player.getY() + 0.06125, this.player.getZ());
                this.tnt.setOldPosAndRot();
                this.tnt.tick();
                if (!this.player.level().isClientSide) {
                    this.setFuse(this.tnt.getFuse());
                    if (!this.tnt.isAlive()) {
                        if (Config.getInstance().getValue("playerDieAfterDestroy", Boolean.class).booleanValue()) {
                            MorphUtils.destroy(this.pl, null);
                        } else {
                            this.deMorph();
                        }
                        this.tnt = null;
                        this.setFuse(-1);
                    }
                }
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("Error while ticking TNT in morphed player " + this.player.getDisplayName().getString(), (Throwable)e);
                this.deMorph();
            }
            finally {
                profiler.pop();
            }
        }
        if (this.player.getRemainingFireTicks() > 0 && !this.player.level().isClientSide) {
            this.runTnt();
        }
    }

    private void deMorph() {
        if (!this.player.level().isClientSide) {
            this.pl.applyBlockMorph(Blocks.AIR.defaultBlockState(), null, BannedBlock.Source.SYSTEM);
        }
    }

    public void setFuse(int i) {
        this.BRAKE_PROGRESS.set(i);
    }

    public boolean runTnt() {
        Block block;
        BlockState state;
        BlockInPlayer2 block2;
        if (this.pl.getBlocksData2().size() == 1 && this.pl.getBlocksData2().containsKey(InPlayerBlockPos.ZERO) && (block2 = this.pl.getBlocksData2().get(InPlayerBlockPos.ZERO)) != null && (state = this.pl.getBlockState(InPlayerBlockPos.ZERO)) != null && (block = state.getBlock()) instanceof TntBlock) {
            TntBlock tntBlock = (TntBlock)block;
            if (this.tnt == null) {
                PrimedTnt TNT;
                TntSpawnLevel lv;
                block7: {
                    lv = new TntSpawnLevel(this.player.level(), state);
                    try {
                        tntBlock.onCaughtFire(state, (Level)lv, block2.getPos(), null, (LivingEntity)this.player);
                    }
                    catch (Exception e) {
                        TNT = lv.extractTnt();
                        if (TNT != null) break block7;
                        MorphUtils.LOGGER.error("Error while init TNT in morphed player " + this.player.getDisplayName().getString(), (Throwable)e);
                        return false;
                    }
                }
                TNT = lv.extractTnt();
                Vec3 ps = MorphUtils.getRealBlockPos(this.pl, block2.getOffset());
                if (TNT == null) {
                    PrimedTnt primedtnt = new PrimedTnt(this.player.level(), ps.x + 0.5, ps.y, ps.z + 0.5, null);
                    this.player.level().playSound(null, primedtnt.getX(), primedtnt.getY(), primedtnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.player.level().gameEvent(null, (Holder)GameEvent.PRIME_FUSE, ps);
                    this.tnt = primedtnt;
                } else {
                    TNT.setPos(ps);
                    this.tnt = TNT;
                }
                ((EntityAccessor)this.tnt).forceLevelChange(this.player.level());
                this.tnt.setNoGravity(true);
                if (this.player.level().isClientSide()) {
                    double d0 = this.player.level().random.nextDouble() * 6.2831854820251465;
                    this.player.setDeltaMovement(new Vec3(-Math.sin(d0) * 0.02, (double)0.3f, -Math.cos(d0) * 0.02));
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public InteractionResult clickTnt(Player clicker, InteractionHand hand, InPlayerBlockPos realPos) {
        BlockState state = this.pl.getBlockState(realPos);
        if (realPos.equals(InPlayerBlockPos.ZERO) && state != null && state.getBlock() instanceof TntBlock) {
            ItemStack itemstack = clicker.getItemInHand(hand);
            if (!itemstack.is(Items.FLINT_AND_STEEL) && !itemstack.is(Items.FIRE_CHARGE)) {
                return null;
            }
            if (!clicker.level().isClientSide && !this.runTnt()) {
                return InteractionResult.FAIL;
            }
            Item item = itemstack.getItem();
            if (!clicker.isCreative()) {
                if (itemstack.is(Items.FLINT_AND_STEEL)) {
                    itemstack.hurtAndBreak(1, (LivingEntity)clicker, LivingEntity.getSlotForHand((InteractionHand)hand));
                } else {
                    itemstack.shrink(1);
                }
            }
            clicker.awardStat(Stats.ITEM_USED.get((Object)item));
            return InteractionResult.SUCCESS;
        }
        return null;
    }

    public void onClientUpdater() {
        if (this.player.level().isClientSide()) {
            int i = (Integer)this.BRAKE_PROGRESS.get();
            if (i < 0) {
                this.tnt = null;
            } else {
                if (this.tnt == null) {
                    this.runTnt();
                }
                if (this.tnt != null) {
                    this.tnt.setFuse(i);
                }
            }
        }
    }

    public void stopRunning() {
        this.tnt = null;
        this.setFuse(-1);
    }

    public PrimedTnt getTnt() {
        return this.tnt;
    }
}

