/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.SavedBlock;
import net.blockomorph.utils.accessors.BlockAccessor;
import net.blockomorph.utils.config.Config;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockmorphCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blockmorph").requires(s -> s.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(arguments -> {
            SavedBlock block = BlockmorphCommand.getBlockForPos((CommandContext<CommandSourceStack>)arguments);
            return BlockmorphCommand.morphMany((CommandSourceStack)arguments.getSource(), block.getState(), EntityArgument.getPlayers((CommandContext)arguments, (String)"targets"), block.getTag());
        }))).executes(arguments -> {
            SavedBlock block = BlockmorphCommand.getBlockForPos((CommandContext<CommandSourceStack>)arguments);
            return BlockmorphCommand.morphSingle((CommandSourceStack)arguments.getSource(), block.getState(), ((CommandSourceStack)arguments.getSource()).getPlayerOrException(), block.getTag());
        }))).then(((RequiredArgumentBuilder)Commands.argument((String)"block", (ArgumentType)BlockStateArgument.block((CommandBuildContext)commandBuildContext)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(arguments -> BlockmorphCommand.morphMany((CommandSourceStack)arguments.getSource(), BlockStateArgument.getBlock((CommandContext)arguments, (String)"block").getState(), EntityArgument.getPlayers((CommandContext)arguments, (String)"targets"), BlockAccessor.of(BlockStateArgument.getBlock((CommandContext)arguments, (String)"block")).getTag())))).executes(arguments -> BlockmorphCommand.morphSingle((CommandSourceStack)arguments.getSource(), BlockStateArgument.getBlock((CommandContext)arguments, (String)"block").getState(), ((CommandSourceStack)arguments.getSource()).getPlayerOrException(), BlockAccessor.of(BlockStateArgument.getBlock((CommandContext)arguments, (String)"block")).getTag()))));
    }

    private static SavedBlock getBlockForPos(CommandContext<CommandSourceStack> arguments) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(arguments, (String)"pos");
        ServerLevel level = ((CommandSourceStack)arguments.getSource()).getLevel();
        BlockState blockState = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        CompoundTag tag = null;
        if (blockEntity != null) {
            try {
                tag = blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            }
            catch (Throwable e) {
                ((CommandSourceStack)arguments.getSource()).sendFailure((Component)Component.literal((String)(e.getMessage() != null ? e.getMessage() : e.getClass().getName())));
            }
        }
        return new SavedBlock(blockState, tag, null);
    }

    private static int morphMany(CommandSourceStack stack, BlockState blockstate, Collection<ServerPlayer> players, CompoundTag tag) throws CommandSyntaxException {
        if (BlockmorphCommand.checkConfig(stack)) {
            return 0;
        }
        BannedBlock global = BannedBlock.isBannedBlock(blockstate, null, BannedBlock.Source.COMMAND);
        if (global != null) {
            stack.sendFailure(global.text());
            return 0;
        }
        int success = 0;
        for (ServerPlayer entity : players) {
            PlayerAccessor pl;
            BannedBlock reason;
            if (!(entity instanceof PlayerAccessor) || (reason = (pl = (PlayerAccessor)entity).applyBlockMorph(blockstate, tag, BannedBlock.Source.COMMAND)) != null) continue;
            ++success;
        }
        if (success == 0) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        int result = success;
        stack.sendSuccess(() -> Component.translatable((String)"blockomorph.morphCommand.many", (Object[])new Object[]{result, blockstate.getBlock().getName()}), true);
        return players.size();
    }

    private static int morphSingle(CommandSourceStack stack, BlockState blockstate, ServerPlayer player, CompoundTag tag) {
        if (BlockmorphCommand.checkConfig(stack)) {
            return 0;
        }
        BannedBlock reason = PlayerAccessor.of((Player)player).applyBlockMorph(blockstate, tag, BannedBlock.Source.COMMAND);
        if (reason != null) {
            stack.sendFailure(reason.text());
            return 0;
        }
        stack.sendSuccess(() -> Component.translatable((String)"blockomorph.morphCommand.single", (Object[])new Object[]{blockstate.getBlock().getName()}), true);
        return 1;
    }

    private static boolean checkConfig(CommandSourceStack stack) {
        if (Config.getInstance() == null) {
            stack.sendFailure((Component)Component.literal((String)"Config not loaded, something works like that... :/"));
            return true;
        }
        return false;
    }
}

