/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import java.util.Optional;
import javax.annotation.Nullable;
import net.blockomorph.utils.ChairController;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.EntityAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, priority=1020)
public abstract class EntityMixin
implements EntityAccessor {
    @Shadow
    private Level level;
    @Unique
    private Vec3 fromMorphedPos;
    private final ChairController CHAIR_CONTROLLER = new ChairController((Entity)this);
    @Unique
    private Vec3 tempPos;
    @Unique
    private Vec3 tpPos;

    @Shadow
    public abstract boolean hasPassenger(Entity var1);

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract boolean startRiding(Entity var1, boolean var2);

    @Override
    public Vec3 getMorphedPos() {
        return this.fromMorphedPos;
    }

    @Override
    @Nullable
    public Vec3 getSyncedPos() {
        CompoundTag tg = this.CHAIR_CONTROLLER.getTagData();
        if (!tg.isEmpty()) {
            Vec3 vec = new Vec3(tg.getDouble("x"), tg.getDouble("y"), tg.getDouble("z"));
            return InPlayerBlockPos.checkOnReal(vec);
        }
        return null;
    }

    @Inject(method={"distanceToSqr(DDD)D"}, at={@At(value="RETURN")}, cancellable=true)
    public void getRealCoordsSqr(double x, double y, double z, CallbackInfoReturnable<Double> cir) {
        MorphUtils.distanceTo(new Vec3(x, y, z), ((Entity)this).position(), true, 0.0, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"distanceToSqr(Lnet/minecraft/world/phys/Vec3;)D"}, at={@At(value="RETURN")}, cancellable=true)
    public void getRealCoordsVec3(Vec3 pos, CallbackInfoReturnable<Double> cir) {
        MorphUtils.distanceTo(pos, ((Entity)this).position(), true, 0.0, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"isAttackable"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkAccess(CallbackInfoReturnable<Boolean> cir) {
        PlayerAccessor pl;
        if (Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand) {
            return;
        }
        EntityMixin entityMixin = this;
        if (entityMixin instanceof PlayerAccessor && (pl = (PlayerAccessor)((Object)entityMixin)).isActive()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setPosRaw"}, at={@At(value="HEAD")})
    public void redirect(double x, double y, double z, CallbackInfo ci) {
        Vec3 vec = new Vec3(x, y, z);
        this.tempPos = InPlayerBlockPos.checkOnReal(vec);
        if (!this.tempPos.equals((Object)vec)) {
            this.fromMorphedPos = vec;
        }
    }

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void correctPos(Entity passanger, Entity.MoveFunction setPosition, CallbackInfo ci) {
        if (this.hasPassenger(passanger)) {
            EntityAccessor acc;
            Vec3 vec3;
            if (passanger instanceof EntityAccessor && (vec3 = (acc = (EntityAccessor)passanger).getSyncedPos()) != null) {
                setPosition.accept(passanger, vec3.x, vec3.y, vec3.z);
                ci.cancel();
            } else if (passanger instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)passanger;
                Optional pos = livingEntity.getSleepingPos();
                pos.ifPresent(blockpos -> {
                    if (InPlayerBlockPos.isMorphedPlayerX(blockpos.getX())) {
                        Vec3 bedPos = InPlayerBlockPos.checkOnReal(Vec3.atCenterOf((Vec3i)blockpos));
                        setPosition.accept(passanger, bedPos.x, bedPos.y + 0.0625, bedPos.z);
                        ci.cancel();
                    }
                });
            }
        }
    }

    @Inject(method={"setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void rejectInvalidMovement(Vec3 vec3, CallbackInfo ci) {
        if (this instanceof Projectile && (vec3.x > 2.9999995E7 || vec3.z > 2.9999995E7 || vec3.z < -2.9999995E7)) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        this.CHAIR_CONTROLLER.tick();
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")})
    public void stopRiding(CallbackInfo ci) {
        this.CHAIR_CONTROLLER.onStopRiding();
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPose(Lnet/minecraft/world/entity/Pose;)V")}, cancellable=true)
    public void startRidingCheck(Entity entity, boolean p_19967_, CallbackInfoReturnable<Boolean> cir) {
        Entity ent = this.CHAIR_CONTROLLER.replaceEntityOnMorphedPlayer(entity);
        if (ent != entity) {
            cir.setReturnValue((Object)true);
            this.startRiding(ent, true);
        }
    }

    @ModifyVariable(method={"setPosRaw"}, at=@At(value="HEAD"), ordinal=0)
    public double getX(double value) {
        return this.tempPos.x;
    }

    @ModifyVariable(method={"setPosRaw"}, at=@At(value="HEAD"), ordinal=1)
    public double getY(double value) {
        return this.tempPos.y;
    }

    @ModifyVariable(method={"setPosRaw"}, at=@At(value="HEAD"), ordinal=2)
    public double getZ(double value) {
        return this.tempPos.z;
    }

    @Inject(method={"absMoveTo(DDD)V"}, at={@At(value="HEAD")})
    public void redirectTp(double x, double y, double z, CallbackInfo ci) {
        this.tpPos = InPlayerBlockPos.checkOnReal(new Vec3(x, y, z));
    }

    @ModifyVariable(method={"absMoveTo(DDD)V"}, at=@At(value="HEAD"), ordinal=0)
    public double getXtp(double value) {
        return this.tpPos.x;
    }

    @ModifyVariable(method={"absMoveTo(DDD)V"}, at=@At(value="HEAD"), ordinal=1)
    public double getYtp(double value) {
        return this.tpPos.y;
    }

    @ModifyVariable(method={"absMoveTo(DDD)V"}, at=@At(value="HEAD"), ordinal=2)
    public double getZtp(double value) {
        return this.tpPos.z;
    }

    @Override
    public void forceLevelChange(Level lv) {
        this.level = lv;
    }
}

