/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.AbstractMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.extensions.IEntityExtension;
import net.neoforged.neoforge.fluids.FluidType;
import org.apache.commons.lang3.function.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class FluidEntitySupportMixin
implements IEntityExtension {
    @Shadow
    private Level level;
    @Shadow
    @Final
    private Set<TagKey<Fluid>> fluidOnEyes;

    @Shadow
    protected abstract void onInsideBlock(BlockState var1);

    @Shadow
    public abstract AABB getBoundingBox();

    @Shadow
    public abstract double getEyeY();

    @Shadow
    public abstract Vec3 getEyePosition();

    @Shadow
    public abstract Vec3 getDeltaMovement();

    @Shadow
    public abstract void setDeltaMovement(Vec3 var1);

    @Shadow
    protected abstract void setFluidTypeHeight(FluidType var1, double var2);

    @Inject(at={@At(value="TAIL")}, method={"checkInsideBlocks"})
    private void checkInsideBlocks(CallbackInfo ci) {
        if (Config.getInstance().getValue("entityInside", Boolean.class).booleanValue()) {
            AABB entityBox = this.getBoundingBox().deflate((double)1.0E-5f);
            Entity self = (Entity)this;
            List entities = this.level.getEntities(self, entityBox, EntitySelector.NO_SPECTATORS);
            for (Entity entity : entities) {
                PlayerAccessor pl;
                if (!(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive()) continue;
                pl.getBlocksData2InArea(entityBox, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(pos, block, realPos) -> {
                    BlockState blockState = block.getBlockState();
                    if (!blockState.isAir()) {
                        blockState.entityInside(this.level, block.getPos(), self);
                        this.onInsideBlock(blockState);
                    }
                }));
            }
        }
    }

    @Inject(method={"updateFluidHeightAndDoFluidPushing()V"}, at={@At(value="TAIL")})
    public void calculateInFluid2(CallbackInfo ci) {
        Object2ObjectArrayMap calcs = new Object2ObjectArrayMap();
        AABB aabb = this.getBoundingBox().deflate(0.001);
        List entities = this.level.getEntities((Entity)this, aabb, EntitySelector.NO_SPECTATORS);
        for (Entity entity : entities) {
            PlayerAccessor pl;
            if (!(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive()) continue;
            pl.getBlocksData2InArea(aabb, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(arg_0, arg_1, arg_2) -> this.lambda$calculateInFluid2$2(aabb, (Object2ObjectMap)calcs, arg_0, arg_1, arg_2)));
        }
        this.calculateLiquidsPower((Object2ObjectMap<FluidType, Object[]>)calcs);
    }

    @Unique
    private void calculateLiquidsPower(Object2ObjectMap<FluidType, Object[]> map) {
        map.forEach((fluidType, objects) -> {
            double fluidHeight = (Double)objects[0];
            Vec3 flow = (Vec3)objects[1];
            int count = (Integer)objects[2];
            if (flow.length() > 0.0) {
                if (count > 0) {
                    flow = flow.scale(1.0 / (double)count);
                }
                if (!(this instanceof Player)) {
                    flow = flow.normalize();
                }
                Vec3 vec32 = this.getDeltaMovement();
                flow = flow.scale(this.getFluidMotionScale((FluidType)fluidType));
                double d2 = 0.003;
                if (Math.abs(vec32.x) < d2 && Math.abs(vec32.z) < d2 && flow.length() < 0.0045000000000000005) {
                    flow = flow.normalize().scale(0.0045000000000000005);
                }
                this.setDeltaMovement(this.getDeltaMovement().add(flow));
            }
            this.setFluidTypeHeight((FluidType)fluidType, fluidHeight);
        });
    }

    @Inject(method={"updateFluidOnEyes"}, at={@At(value="TAIL")})
    public void getLiquid(CallbackInfo ci) {
        FluidState fluidState;
        double height;
        BlockInPlayer2 block;
        double y;
        AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2> liquid = this.getLiquid(this.getEyePosition());
        if (liquid != null && (y = MorphUtils.getRealBlockPos((PlayerAccessor)liquid.getKey(), (InPlayerBlockPos)block.getOffset()).y) + (height = (double)(fluidState = (block = liquid.getValue()).getBlockState().getFluidState()).getHeight((BlockGetter)this.level, block.getPos())) > this.getEyeY()) {
            fluidState.getTags().forEach(tag -> this.fluidOnEyes.add((TagKey<Fluid>)tag));
        }
    }

    @Unique
    private AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2> getLiquid(Vec3 position) {
        Entity self = (Entity)this;
        AtomicReference reference = new AtomicReference();
        List entities = this.level.getEntities(self, new AABB(BlockPos.ZERO).move(position.add(-0.5, -0.5, -0.5)), EntitySelector.NO_SPECTATORS);
        MorphUtils.doBlockInMorphedPlayerOnPos(self, entities, position, (pl, block) -> {
            if (block.shouldDoFluidAction()) {
                reference.set(new AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2>((PlayerAccessor)pl, (BlockInPlayer2)block));
            }
        });
        return (AbstractMap.SimpleEntry)reference.get();
    }

    private /* synthetic */ void lambda$calculateInFluid2$2(AABB aabb, Object2ObjectMap calcs, InPlayerBlockPos pos, BlockInPlayer2 block, Vec3 realPos) {
        if (block.shouldDoFluidAction()) {
            FluidState fluidState = block.getBlockState().getFluidState();
            FluidType type = fluidState.getFluidType();
            double fluidHeight = realPos.y + (double)fluidState.getHeight((BlockGetter)this.level, block.getPos());
            if (fluidHeight >= aabb.minY) {
                Object[] list = (Object[])calcs.computeIfAbsent((Object)type, o -> {
                    Object[] objs = new Object[]{0.0, Vec3.ZERO, 0};
                    return objs;
                });
                list[0] = Math.max(fluidHeight - aabb.minY, (Double)list[0]);
                if (this.isPushedByFluid(type)) {
                    Vec3 flowSpeed = fluidState.getFlow((BlockGetter)this.level, block.getPos());
                    if ((Double)list[0] < 0.4) {
                        flowSpeed = flowSpeed.scale(((Double)list[0]).doubleValue());
                    }
                    list[1] = ((Vec3)list[1]).add(flowSpeed);
                    list[2] = (Integer)list[2] + 1;
                }
            }
        }
    }
}

