/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.blockFix;

import java.util.List;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EndPortalBlock.class})
public abstract class EndPortalMixin
implements Portal {
    @Shadow
    @Final
    protected static VoxelShape SHAPE;

    @Inject(method={"entityInside"}, at={@At(value="HEAD")}, cancellable=true)
    public void inside(BlockState blockState, Level level, BlockPos blockPos, Entity entity, CallbackInfo ci) {
        InPlayerBlockPos.check(blockPos, (pl, realPos) -> {
            Vec3 vec;
            AABB aabb;
            List aabbs;
            ci.cancel();
            if (entity.canUsePortal(false) && !(aabbs = SHAPE.toAabbs()).isEmpty() && (aabb = (AABB)aabbs.getFirst()).move(vec = MorphUtils.getRealBlockPos(pl, realPos)).intersects(entity.getBoundingBox())) {
                if (!level.isClientSide && level.dimension() == Level.END && entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (!serverPlayer.seenCredits) {
                        serverPlayer.showEndCredits();
                        return;
                    }
                }
                entity.setAsInsidePortal((Portal)this, blockPos);
            }
        }, () -> ((CallbackInfo)ci).cancel(), (LevelReader)level);
    }
}

