/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client.graphic.fluidFog;

import java.util.Arrays;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Camera.class})
public abstract class CameraMixin {
    @Shadow
    private boolean initialized;
    @Shadow
    private BlockGetter level;
    @Shadow
    private Vec3 position;
    @Shadow
    private Entity entity;

    @Shadow
    public abstract Camera.NearPlane getNearPlane();

    @Inject(method={"getFluidInCamera"}, at={@At(value="HEAD")}, cancellable=true)
    public void getVanillaFluid(CallbackInfoReturnable<FogType> cir) {
        BlockGetter blockGetter;
        if (this.initialized && (blockGetter = this.level) instanceof ClientLevel) {
            ClientLevel lv = (ClientLevel)blockGetter;
            Camera.NearPlane nearPlane = this.getNearPlane();
            for (Vec3 pos : Arrays.asList(nearPlane.getPointOnPlane(0.0f, 0.0f), nearPlane.getTopLeft(), nearPlane.getTopRight(), nearPlane.getBottomLeft(), nearPlane.getBottomRight())) {
                Vec3 position = this.position.add(pos);
                MorphUtils.doBlockInMorphedPlayerOnPos(this.entity, lv.entitiesForRendering(), position, (pl, block) -> {
                    FluidState fluidState;
                    if (block.getBlockState().is(Blocks.POWDER_SNOW)) {
                        cir.setReturnValue((Object)FogType.POWDER_SNOW);
                    } else if (block.shouldDoFluidAction() && position.y < MorphUtils.getRealBlockPos((PlayerAccessor)pl, (InPlayerBlockPos)block.getOffset()).y + (double)(fluidState = block.getBlockState().getFluidState()).getHeight(this.level, block.getPos())) {
                        if (fluidState.is(FluidTags.WATER)) {
                            cir.setReturnValue((Object)FogType.WATER);
                        } else if (fluidState.is(FluidTags.LAVA)) {
                            cir.setReturnValue((Object)FogType.LAVA);
                        }
                    }
                });
            }
        }
    }
}

