/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client.graphic.fluidFog;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.blockomorph.screens.utils.FogLiquidModifier;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.FastColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Shadow
    private static float fogRed;
    @Shadow
    private static float fogGreen;
    @Shadow
    private static float fogBlue;
    private static final FogLiquidModifier LIQUID_MODIFIER;

    @Inject(method={"setupColor"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clearColor(FFFF)V", ordinal=1, remap=false)})
    private static void setCol(Camera camera, float f, ClientLevel clientLevel, int i, float g, CallbackInfo ci) {
        FogLiquidModifier.LiquidFogData fogData = LIQUID_MODIFIER.getFog(GuiUtils.MC.level.entitiesForRendering(), false);
        if (fogData == null) {
            return;
        }
        int color = fogData.color();
        fogRed = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        fogGreen = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        fogBlue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
    }

    @Inject(method={"setupFog"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderFogStart(F)V", remap=false)}, cancellable=true)
    private static void setF(Camera camera, FogRenderer.FogMode fogMode, float f, boolean bl, float g, CallbackInfo ci) {
        FogLiquidModifier.LiquidFogData fogData = LIQUID_MODIFIER.getFog(GuiUtils.MC.level.entitiesForRendering(), false);
        if (fogData == null) {
            return;
        }
        FogShape shape = FogShape.SPHERE;
        float end = fogData.end();
        if (FastColor.ARGB32.alpha((int)FastColor.ARGB32.alpha((int)fogData.color())) <= 235) {
            int renderDistance = GuiUtils.MC.options.getEffectiveRenderDistance();
            if (fogData.end() > (float)renderDistance) {
                shape = FogShape.CYLINDER;
                end = renderDistance;
            }
        }
        RenderSystem.setShaderFogStart((float)fogData.start());
        RenderSystem.setShaderFogEnd((float)end);
        RenderSystem.setShaderFogShape((FogShape)shape);
        ci.cancel();
    }

    static {
        LIQUID_MODIFIER = new FogLiquidModifier();
    }
}

