/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import net.blockomorph.utils.coords.DummyChunkStorage;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.coords.PlayerMorphedSection;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerChunkCache.class})
public class ServerChunkCacheMixin {
    @Shadow
    @Final
    public ServerLevel level;
    @Unique
    private final DummyChunkStorage CHUNKS = new DummyChunkStorage();

    @Inject(method={"blockChanged"}, at={@At(value="HEAD")}, cancellable=true)
    public void redirectChange(BlockPos pos, CallbackInfo ci) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            ci.cancel();
            pl.prepareSync((InPlayerBlockPos)realPos);
        }, () -> ((CallbackInfo)ci).cancel(), (LevelReader)this.level);
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/status/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/ChunkAccess;"}, at={@At(value="HEAD")}, cancellable=true)
    public void dummyChunk(int x, int z, ChunkStatus p_46504_, boolean p_46505_, CallbackInfoReturnable<ChunkAccess> cir) {
        this.CHUNKS.getFakeChunk(x, z, cir, (Level)this.level);
    }

    @Inject(method={"hasChunk"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasDummyChunk(int x, int z, CallbackInfoReturnable<Boolean> cir) {
        this.CHUNKS.hasChunk(x, z, cir);
    }

    @ModifyVariable(method={"updateChunkForced", "getChunkDebugData"}, at=@At(value="HEAD"))
    public ChunkPos changePos(ChunkPos orig) {
        return this.getChangedChunk(orig);
    }

    @ModifyVariable(method={"removeRegionTicket(Lnet/minecraft/server/level/TicketType;Lnet/minecraft/world/level/ChunkPos;ILjava/lang/Object;Z)V", "addRegionTicket(Lnet/minecraft/server/level/TicketType;Lnet/minecraft/world/level/ChunkPos;ILjava/lang/Object;Z)V"}, at=@At(value="HEAD"), remap=false)
    public ChunkPos changePosRemove(ChunkPos orig) {
        return this.getChangedChunk(orig);
    }

    @Unique
    private ChunkPos getChangedChunk(ChunkPos orig) {
        Player pl = PlayerMorphedSection.getPlayerByChunkPos(orig, this.level.isClientSide);
        if (pl != null) {
            return pl.chunkPosition();
        }
        if (InPlayerBlockPos.isMorphPlayerChunk(orig)) {
            return ChunkPos.ZERO;
        }
        return orig;
    }
}

