/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.network;

import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.screens.morphConfig.nbtEditor.PlayerBlockEntityNbtEditor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class ClientBoundServerBlockEntityTagPacket
implements BlockMorphPacket {
    public static final String ID = "client_bound_server_block_entity_packet";
    CompoundTag tagForGui;
    boolean message;

    private ClientBoundServerBlockEntityTagPacket(CompoundTag tagForGui, boolean message) {
        this.tagForGui = tagForGui;
        this.message = message;
    }

    public ClientBoundServerBlockEntityTagPacket(FriendlyByteBuf buffer) {
        this.tagForGui = buffer.readNbt();
        this.message = buffer.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeNbt((Tag)this.tagForGui);
        buffer.writeBoolean(this.message);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void handle(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof PlayerBlockEntityNbtEditor) {
            PlayerBlockEntityNbtEditor nbtEditor = (PlayerBlockEntityNbtEditor)screen;
            if (this.message) {
                if (this.tagForGui != null) {
                    boolean exc = this.tagForGui.getBoolean("exc");
                    MutableComponent text = Component.translatable((String)(exc ? "blockomorph.gui.nbtEditor.parseError.exception" : "blockomorph.gui.nbtEditor.parseError.save"));
                    String error = text.getString() + this.tagForGui.getString("err");
                    nbtEditor.setError(error);
                }
            } else {
                nbtEditor.setNewTag(this.tagForGui);
            }
        }
    }

    public static ClientBoundServerBlockEntityTagPacket createForTag(CompoundTag tag) {
        return new ClientBoundServerBlockEntityTagPacket(tag, false);
    }

    public static ClientBoundServerBlockEntityTagPacket createForError(String error, boolean isException) {
        CompoundTag tag = new CompoundTag();
        tag.putString("err", error);
        tag.putBoolean("exc", isException);
        return new ClientBoundServerBlockEntityTagPacket(tag, true);
    }
}

