/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.network;

import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.utils.MorphUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MainPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<MainPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"blockomorph", (String)"main_packet"));
    ResourceLocation id;
    BlockMorphPacket packet;
    public static final StreamCodec<RegistryFriendlyByteBuf, MainPacket> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeResourceLocation(message.id);
        message.packet.write((FriendlyByteBuf)buffer);
    }, MainPacket::new);

    public MainPacket(BlockMorphPacket packet) {
        this.id = ResourceLocation.fromNamespaceAndPath((String)"blockomorph", (String)packet.getId());
        this.packet = packet;
    }

    public MainPacket(FriendlyByteBuf buf) {
        this.id = buf.readResourceLocation();
        MorphUtils.PacketInfo suppl = MorphUtils.getHandler(this.id);
        if (suppl.packet() != null) {
            this.packet = suppl.packet().apply(buf);
        }
    }

    public static void apply(MainPacket message, IPayloadContext context) {
        context.enqueueWork(() -> {
            MorphUtils.PacketInfo suppl = MorphUtils.getHandler(message.id);
            if (message.packet == null || suppl == null) {
                throw new IllegalArgumentException("Unknown packet type received!");
            }
            boolean cl = suppl.isClient();
            PacketFlow dir = context.flow();
            if (dir == PacketFlow.CLIENTBOUND && !cl || dir == PacketFlow.SERVERBOUND && cl) {
                throw new IllegalArgumentException("Wrong side for packet!");
            }
            message.packet.handle(context.player());
        }).exceptionally(e -> {
            context.connection().disconnect((Component)Component.literal((String)("Broken BlockMorphPacket with ID " + String.valueOf(message.id) + ": " + e.getMessage())));
            return null;
        });
    }

    public String toString() {
        return "BlockMorphMainPacket: " + String.valueOf(this.id);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

