/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens;

import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AbstractScreen
extends Screen {
    public final GuiUtils gui = new GuiUtils();
    public final int imageLength;
    public final int imageHeight;
    protected int leftPos;
    protected int topPos;
    private final ResourceLocation MENU;

    protected AbstractScreen(String id, @Nullable ScreenPosition size) {
        super((Component)Component.literal((String)id));
        this.MENU = GuiUtils.res("textures/screens/" + id + ".png");
        if (size == null) {
            this.imageLength = 176;
            this.imageHeight = 166;
        } else {
            this.imageLength = size.x();
            this.imageHeight = size.y();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float tick) {
        this.gui.setGuiGraphics(guiGraphics, this.font, mouseX, mouseY, tick);
        super.render(guiGraphics, mouseX, mouseY, tick);
    }

    public final boolean mouseScrolled(double mouseX, double mouseY, double xScrollOffset, double yScrollOffset) {
        return this.mouseScrolled(mouseX, mouseY, yScrollOffset);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double yScrollOffset) {
        return super.mouseScrolled(mouseX, mouseY, 0.0, yScrollOffset);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float tick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, tick);
        this.renderMenu();
    }

    public Font getFont() {
        return this.font;
    }

    protected void renderMenu() {
        this.gui.blitMonoImage(this.MENU, this.leftPos, this.topPos, this.imageLength, this.imageHeight);
    }

    protected void init() {
        this.leftPos = (this.width - this.imageLength) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
    }
}

