/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.config;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface ConfigRenderer<T extends ConfigInstance<?>> {
    public static final String LOCAL_KEY = "blockomorph.config_option.";
    public static final int MAX_NAME_WIDTH = 85;
    public static final int MAX_Y = 119;
    public static final int MAX_X = 186;
    public static final ResourceLocation PLATES_SPRITE = GuiUtils.res("textures/screens/configs.png");

    public void renderBackground(GuiUtils var1, T var2, Rect2i var3);

    public void render(GuiUtils var1, T var2, Rect2i var3);

    public boolean mouseClicked(T var1, double var2, double var4, Rect2i var6, ConfigRenderingContext var7);

    public boolean mouseScrolled(T var1, double var2, double var4, double var6, Rect2i var8, ConfigRenderingContext var9);

    default public void renderOptionName(GuiUtils gui, T configInstance, Rect2i box) {
        MutableComponent name = Component.translatable((String)(LOCAL_KEY + ((ConfigInstance)configInstance).getName()));
        int stringLength = gui.getFont().width(name.getString());
        if (stringLength > 85) {
            name = Component.literal((String)(gui.getFont().plainSubstrByWidth(name.getString(), 85) + ".."));
        }
        gui.drawString((Component)name, box.getX() + 4, box.getY() + 5, this.getOptionColor(configInstance), false);
    }

    default public void renderTooltip(GuiUtils gui, T configInstance, Rect2i box) {
        if (GuiUtils.isMouseOver(box.getX(), box.getY(), box.getX() + 85 + 5, box.getY() + box.getHeight(), gui.getMouseX(), gui.getMouseY())) {
            ArrayList<Component> tooltips = new ArrayList<Component>();
            Component tooltip = this.getTooltip(gui, configInstance);
            if (tooltip != null) {
                tooltips.add(tooltip);
            }
            if (((ConfigInstance)configInstance).getTooltip() != null) {
                tooltips.add(((ConfigInstance)configInstance).getTooltip());
            }
            gui.renderTooltip(tooltips, gui.getMouseX(), gui.getMouseY());
        }
    }

    @Nullable
    default public Component getTooltip(GuiUtils gui, T configInstance) {
        MutableComponent name = Component.translatable((String)(LOCAL_KEY + ((ConfigInstance)configInstance).getName()));
        if (gui.getFont().width(name.getString()) > 85) {
            return name;
        }
        return null;
    }

    default public int getOptionColor(T configInstance) {
        return -1;
    }

    default public void startClick() {
    }

    default public void endClick() {
    }

    default public void init() {
    }

    public record ConfigRenderingContext(Screen parentScreen, BiConsumer<String, String> onValueChanged, Consumer<Screen> onNewScreenRequested, Consumer<ConfigInstance<?>> onEnteringRequested) {
    }
}

