/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morph;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.blockomorph.screens.AbstractScreen;
import net.blockomorph.screens.morph.BlocksManager;
import net.blockomorph.screens.morph.ConfigSyncListener;
import net.blockomorph.screens.morph.TabManager;
import net.blockomorph.screens.morphConfig.MorphConfigScreen;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.SavedBlock;
import net.blockomorph.utils.SavedBlockManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;

public abstract class AbstractMorphScreen
extends AbstractScreen
implements ConfigSyncListener {
    private static final ResourceLocation SEARCH_BAR = GuiUtils.res("textures/screens/searchbar.png");
    private static final ResourceLocation MODE_TABS = GuiUtils.res("textures/screens/exit_tabs.png");
    public static final SavedBlockManager SAVED_BLOCK_MANAGER = new SavedBlockManager(MorphUtils.getGameDir());
    protected static final int BLOCK_FRAME_SIZE = 36;
    public final TabManager TAB_MANAGER;
    public final BlocksManager BLOCKS_MANAGER;
    protected PlayerAccessor player;
    protected MorphScreenOptions options;
    protected boolean ignoreSearchBoxInput;

    protected AbstractMorphScreen(MorphScreenOptions options) {
        super("morph_screen", null);
        this.options = options;
        this.player = PlayerAccessor.of((Player)GuiUtils.MC.player);
        this.BLOCKS_MANAGER = new BlocksManager(this);
        this.TAB_MANAGER = new TabManager(this, options.useAllowedTab(), options.useSavedBlocksTab());
    }

    protected void setUseUpperTabs(boolean yes) {
        this.options = new MorphScreenOptions(this.options.useAllowedTab, this.options.useSavedBlocksTab, yes);
    }

    protected abstract void initAdditional(Consumer<AbstractWidget> var1);

    protected abstract void renderFrame(SavedBlock var1, int var2, int var3);

    protected abstract SoundInstance onClickOnBlock(SavedBlock var1, int var2, CreativeModeTab var3, int var4);

    protected void renderTooltip() {
        SavedBlock block = this.BLOCKS_MANAGER.getBlockAtPosition(this.gui.getMouseX(), this.gui.getMouseY());
        if (block != null) {
            MutableComponent name = block.getName() == null ? block.getState().getBlock().getName() : Component.literal((String)block.getName());
            this.gui.renderTooltip((Component)name, this.gui.getMouseX(), this.gui.getMouseY());
        }
    }

    public void tick() {
        this.player = PlayerAccessor.of((Player)GuiUtils.MC.player);
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public PlayerAccessor getPlayer() {
        return this.player;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float tick) {
        super.render(guiGraphics, mouseX, mouseY, tick);
        this.renderContent();
        this.renderTooltip();
    }

    private void renderContent() {
        this.TAB_MANAGER.renderTabs(this.gui);
        this.BLOCKS_MANAGER.render(this.gui, this::renderFrame);
    }

    @Override
    public void renderMenu() {
        super.renderMenu();
        if (this.options.useUpperTabs()) {
            this.gui.blit(MODE_TABS, this.leftPos + 4, this.topPos - 19, 0.0f, 0.0f, 80, 22, 80, 46);
        }
        if (this.TAB_MANAGER.hasSearchBar()) {
            this.gui.blitMonoImage(SEARCH_BAR, this.leftPos + 90, this.topPos - 19, 80, 23);
        }
    }

    public boolean mouseClicked(double x, double y, int type) {
        if (type == 0) {
            if (this.TAB_MANAGER.mouseClicked(x, y)) {
                return true;
            }
            if (this.BLOCKS_MANAGER.mouseClicked(x, y, this::onClickOnBlock)) {
                return true;
            }
            if (this.options.useUpperTabs && x > (double)(this.leftPos + 4) && x < (double)(this.leftPos + 4 + 41) && y > (double)(this.topPos - 19) && y < (double)(this.topPos - 19 + 22)) {
                GuiUtils.MC.setScreen((Screen)new MorphConfigScreen());
                return true;
            }
        }
        return super.mouseClicked(x, y, type);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int type, double mouseXOffset, double mouseYOffset) {
        if (this.BLOCKS_MANAGER.scrollerManager.mouseDragged(mouseY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, type, mouseXOffset, mouseYOffset);
    }

    public boolean mouseReleased(double x, double y, int type) {
        if (type == 0) {
            if (this.TAB_MANAGER.mouseClicked(x, y)) {
                return true;
            }
            this.BLOCKS_MANAGER.scrollerManager.disableScrollWork();
        }
        return super.mouseReleased(x, y, type);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double yScrolled) {
        if (this.BLOCKS_MANAGER.scrollerManager.mouseScrolled(yScrolled)) {
            return true;
        }
        return super.mouseScrolled(x, y, yScrolled);
    }

    public AbstractMorphScreen ignoreInitInput() {
        this.ignoreSearchBoxInput = true;
        return this;
    }

    public boolean charTyped(char codePoint, int mods) {
        if (this.ignoreSearchBoxInput) {
            this.ignoreSearchBoxInput = false;
            return false;
        }
        if (this.TAB_MANAGER.getSearchBox().charTyped(codePoint, mods)) {
            return true;
        }
        return super.charTyped(codePoint, mods);
    }

    public boolean keyPressed(int keyboardButton, int scanCode, int mods) {
        if (keyboardButton == 256) {
            this.onClose();
        } else if (this.TAB_MANAGER.getSearchBox().keyPressed(keyboardButton, scanCode, mods)) {
            return true;
        }
        return super.keyPressed(keyboardButton, scanCode, mods);
    }

    @Override
    protected void init() {
        super.init();
        this.initAdditional(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.TAB_MANAGER.init(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        ArrayList<CreativeModeTab> tabs = new ArrayList<CreativeModeTab>(this.TAB_MANAGER.CONTENT_TABS);
        tabs.addAll(this.TAB_MANAGER.SPECIAL_TABS);
        if (!tabs.contains(TabManager.selectedTab)) {
            TabManager.selectedTab = CreativeModeTabs.getDefaultTab();
        }
        this.TAB_MANAGER.selectTab(TabManager.getSelectedTab());
    }

    public void resize(Minecraft minecraft, int width, int height) {
        ScrollerManager<SavedBlock> manager = this.BLOCKS_MANAGER.scrollerManager;
        float scroll = manager.getScrollerOffset();
        String value = this.TAB_MANAGER.getSearchBox().getValue();
        super.resize(minecraft, width, height);
        this.TAB_MANAGER.getSearchBox().setValue(value);
        this.BLOCKS_MANAGER.searchBlocks(value);
        manager.setScrollOffset(scroll);
        manager.refreshList();
    }

    @Override
    public void onConfigSynced() {
        this.BLOCKS_MANAGER.updateAllowedBlocks();
    }

    public record MorphScreenOptions(boolean useAllowedTab, boolean useSavedBlocksTab, boolean useUpperTabs) {
        public static MorphScreenOptions ALL = new MorphScreenOptions(true, true, true);
        public static MorphScreenOptions CONFIG = new MorphScreenOptions(false, true, false);
        public static MorphScreenOptions OFF = new MorphScreenOptions(false, false, false);
    }

    @FunctionalInterface
    public static interface OnRenderingFrame {
        public void render(SavedBlock var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface OnBlockClick {
        public SoundInstance click(SavedBlock var1, int var2, CreativeModeTab var3, int var4);
    }
}

