/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morph;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.blockomorph.screens.morph.AbstractMorphScreen;
import net.blockomorph.screens.morph.TabManager;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.SavedBlock;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlocksManager {
    protected static final ResourceKey<CreativeModeTab> ALLOWED_TAB_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)GuiUtils.res("allowed_blocks"));
    protected static final HashMap<ResourceKey<CreativeModeTab>, List<SavedBlock>> ALL_TAB_CONTENTS = new HashMap();
    protected final List<SavedBlock> renderableBlocks = new ArrayList<SavedBlock>(16){

        @Override
        public SavedBlock get(int index) {
            if (index >= this.size() || index < 0) {
                return null;
            }
            return (SavedBlock)super.get(index);
        }
    };
    protected static List<Block> ALL_BLOCKS;
    private static FeatureFlagSet FEATURE_FLAGS;
    private static HolderLookup.Provider HOLDER;
    public final ScrollerManager<SavedBlock> scrollerManager;
    private final AbstractMorphScreen parentScreen;

    public BlocksManager(AbstractMorphScreen screen) {
        this.parentScreen = screen;
        this.scrollerManager = new ScrollerManager<SavedBlock>(() -> screen.getLeftPos() + 158, () -> screen.getTopPos() + 16, 142, 4, 4, this.renderableBlocks, null);
    }

    public void render(GuiUtils gui, AbstractMorphScreen.OnRenderingFrame onRendering) {
        int size = 36;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                BlockEntity blockEntity;
                SavedBlock block = this.renderableBlocks.get(y * 4 + x);
                if (block == null) continue;
                Block block2 = block.getState().getBlock();
                if (block2 instanceof EntityBlock) {
                    EntityBlock ent = (EntityBlock)block2;
                    v0 = ent.newBlockEntity(GuiUtils.AIR, block.getState());
                } else {
                    v0 = blockEntity = null;
                }
                if (blockEntity != null) {
                    blockEntity.setLevel((Level)GuiUtils.MC.level);
                    if (block.getTag() != null) {
                        blockEntity.loadWithComponents(block.getTag(), (HolderLookup.Provider)this.parentScreen.getPlayer().player().registryAccess());
                    }
                }
                gui.renderBlockInGui(block.getState(), blockEntity, this.parentScreen.getLeftPos() + 42 + x * size, this.parentScreen.getTopPos() + 42 + y * size, 20.0f);
                gui.renderAdditionalOnBlock(block.getState(), this.parentScreen.getLeftPos() + 20 + x * size, this.parentScreen.getTopPos() + 25 + y * size, 30.0f);
                int blockX = x;
                int blockY = y;
                gui.renderInDepthIfNeededAfterBlockRendering(() -> onRendering.render(block, this.parentScreen.getLeftPos() + 10 + blockX * size, this.parentScreen.getTopPos() + 15 + blockY * size));
            }
        }
        this.scrollerManager.renderScroller(gui);
    }

    @Nullable
    public SavedBlock getBlockAtPosition(double x, double y) {
        return this.renderableBlocks.get(this.findBlockIndex(x, y));
    }

    public int findBlockIndex(double mouseX, double mouseY) {
        int size = 36;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int blockY;
                int blockX = this.parentScreen.getLeftPos() + 10 + x * size;
                if (!GuiUtils.isMouseOver(blockX, blockY = this.parentScreen.getTopPos() + 15 + y * size, blockX + size - 1, blockY + size, mouseX, mouseY)) continue;
                return y * 4 + x;
            }
        }
        return -1;
    }

    public List<CreativeModeTab> sortTabsIfItemsIsBlocks() {
        LocalPlayer player = (LocalPlayer)this.parentScreen.getPlayer();
        FeatureFlagSet set = player.connection.enabledFeatures();
        RegistryAccess holder = player.level().registryAccess();
        if (!set.equals((Object)FEATURE_FLAGS) || HOLDER != holder) {
            ALL_TAB_CONTENTS.clear();
            ALL_BLOCKS = BuiltInRegistries.BLOCK.stream().filter(block -> block.isEnabled(set)).toList();
            this.putContentTabs(set);
            this.putSearchTab();
            this.putUnsortableTab();
        }
        this.putSavedTab();
        this.putAllowedTab();
        FEATURE_FLAGS = set;
        HOLDER = holder;
        return BuiltInRegistries.CREATIVE_MODE_TAB.stream().map(tab -> {
            List<SavedBlock> list;
            ResourceKey<CreativeModeTab> key = TabManager.getKeyFromTab(tab);
            if (tab.getType() == CreativeModeTab.Type.CATEGORY && key != CreativeModeTabs.OP_BLOCKS && (list = ALL_TAB_CONTENTS.get(key)) != null && !list.isEmpty()) {
                return tab;
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public void searchBlocks(String searchName) {
        TabManager tabs = this.parentScreen.TAB_MANAGER;
        if (tabs.hasSearchBar()) {
            if (searchName.isEmpty()) {
                tabs.selectTab(TabManager.selectedTab);
            } else {
                List<SavedBlock> list = ALL_TAB_CONTENTS.get(TabManager.getKeyFromTab(TabManager.selectedTab));
                if (list != null) {
                    this.scrollerManager.setScrollOffset(0.0f);
                    List<SavedBlock> blocks = list.stream().filter(block -> {
                        String name = block.getName() != null ? block.getName() : block.getState().getBlock().getName().getString();
                        return name.toLowerCase().contains(searchName.toLowerCase());
                    }).toList();
                    this.scrollerManager.setMainList(blocks);
                    this.scrollerManager.refreshList();
                }
            }
        }
    }

    public boolean mouseClicked(double x, double y, AbstractMorphScreen.OnBlockClick click) {
        SavedBlock block = this.parentScreen.BLOCKS_MANAGER.getBlockAtPosition(x, y);
        if (block != null) {
            SoundInstance sound = click.click(block, this.parentScreen.BLOCKS_MANAGER.findBlockIndex(x, y), TabManager.getSelectedTab(), TabManager.getTabPage());
            if (sound != null) {
                GuiUtils.MC.getSoundManager().play(sound);
            }
            return true;
        }
        return this.scrollerManager.mouseClicked(x, y);
    }

    protected void putContentTabs(FeatureFlagSet set) {
        BuiltInRegistries.CREATIVE_MODE_TAB.entrySet().forEach(entry -> {
            ResourceKey key = (ResourceKey)entry.getKey();
            CreativeModeTab tab = (CreativeModeTab)entry.getValue();
            if (tab.getType() == CreativeModeTab.Type.CATEGORY) {
                List<SavedBlock> blocks = tab.getDisplayItems().stream().map(item -> {
                    BlockItem block;
                    Item patt0$temp = item.getItem();
                    if (patt0$temp instanceof BlockItem && (block = (BlockItem)patt0$temp).isEnabled(set)) {
                        return new SavedBlock(this.prepareBlockStateTag(block.getBlock().defaultBlockState(), (ItemStack)item), this.getTagForBlockEntity((ItemStack)item), null);
                    }
                    return null;
                }).filter(Objects::nonNull).toList();
                ALL_TAB_CONTENTS.put((ResourceKey<CreativeModeTab>)key, blocks);
            }
        });
    }

    @Nullable
    private CompoundTag getTagForBlockEntity(ItemStack stack) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty()) {
            return customData.copyTag();
        }
        return null;
    }

    private BlockState prepareBlockStateTag(BlockState blockState, ItemStack item) {
        BlockItemStateProperties properties = (BlockItemStateProperties)item.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
        if (!properties.isEmpty()) {
            return properties.apply(blockState);
        }
        return blockState;
    }

    protected void putSearchTab() {
        ALL_TAB_CONTENTS.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.SEARCH, ALL_BLOCKS.stream().map(block -> new SavedBlock(block.defaultBlockState(), null, null)).toList());
    }

    protected void putUnsortableTab() {
        ArrayList newList = new ArrayList();
        ALL_BLOCKS.forEach(block -> {
            boolean contains = false;
            block0: for (Map.Entry<ResourceKey<CreativeModeTab>, List<SavedBlock>> entry : ALL_TAB_CONTENTS.entrySet()) {
                if (entry.getKey() == CreativeModeTabs.SEARCH) continue;
                List<SavedBlock> list = entry.getValue();
                for (SavedBlock block2 : list) {
                    if (block2.getState() == null || block2.getState().getBlock() != block) continue;
                    contains = true;
                    continue block0;
                }
            }
            if (!contains && !newList.contains(block)) {
                newList.add(block);
            }
        });
        List<SavedBlock> old = ALL_TAB_CONTENTS.get(CreativeModeTabs.OP_BLOCKS);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (old != null) {
            builder.addAll(old);
        }
        builder.addAll(newList.stream().map(block -> new SavedBlock(block.defaultBlockState(), null, null)).toList());
        ALL_TAB_CONTENTS.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.OP_BLOCKS, (List<SavedBlock>)builder.build());
    }

    protected void putSavedTab() {
        ALL_TAB_CONTENTS.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.HOTBAR, AbstractMorphScreen.SAVED_BLOCK_MANAGER.get().values().stream().toList());
    }

    protected void putAllowedTab() {
        ALL_TAB_CONTENTS.put(ALLOWED_TAB_KEY, ALL_BLOCKS.stream().map(block -> {
            BannedBlock reason = BannedBlock.isBannedBlock(block.defaultBlockState(), this.parentScreen.getPlayer(), BannedBlock.Source.SYSTEM);
            if (reason == null || reason.systemLock()) {
                return new SavedBlock(block.defaultBlockState(), null, null);
            }
            return null;
        }).filter(Objects::nonNull).toList());
    }

    protected void updateAllowedBlocks() {
        this.putAllowedTab();
        TabManager tabs = this.parentScreen.TAB_MANAGER;
        tabs.putAllowedTabIfNeed();
        if (TabManager.selectedTab == TabManager.ALLOWED_TAB) {
            if (tabs.SPECIAL_TABS.contains(TabManager.ALLOWED_TAB)) {
                tabs.selectTab(TabManager.ALLOWED_TAB);
            } else {
                tabs.selectTab(CreativeModeTabs.getDefaultTab());
            }
        }
    }
}

