/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morph;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.blockomorph.screens.morph.AbstractMorphScreen;
import net.blockomorph.screens.morph.BlocksManager;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ListenerEditBox;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.SavedBlock;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TabManager {
    protected static final CreativeModeTab ALLOWED_TAB = CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).title((Component)Component.translatable((String)"blockomorph.gui.morphScreen.allowed_tab")).icon(() -> new ItemStack((ItemLike)Items.NETHER_STAR)).build();
    private static final ResourceLocation TABS_SPRITE = GuiUtils.res("textures/screens/block_selector_tabs.png");
    protected final AbstractMorphScreen parentScreen;
    protected final List<CreativeModeTab> CONTENT_TABS;
    protected final List<CreativeModeTab> SPECIAL_TABS;
    protected static CreativeModeTab selectedTab = CreativeModeTabs.getDefaultTab();
    protected static int tabPage = 0;
    protected final int pageCount;
    protected EditBox searchBox;
    protected final boolean needAllowedTab;

    public TabManager(AbstractMorphScreen screen, boolean useAllowedTab, boolean useSavedBlocksTab) {
        this.parentScreen = screen;
        this.needAllowedTab = useAllowedTab;
        AbstractMorphScreen.SAVED_BLOCK_MANAGER.load();
        this.initTabs();
        ArrayList<CreativeModeTab> list = new ArrayList<CreativeModeTab>();
        list.add(CreativeModeTabs.searchTab());
        list.add(TabManager.getTabFromKey((ResourceKey<CreativeModeTab>)CreativeModeTabs.OP_BLOCKS));
        if (useSavedBlocksTab) {
            list.add(TabManager.getTabFromKey((ResourceKey<CreativeModeTab>)CreativeModeTabs.HOTBAR));
        }
        this.SPECIAL_TABS = list;
        this.CONTENT_TABS = screen.BLOCKS_MANAGER.sortTabsIfItemsIsBlocks();
        this.putAllowedTabIfNeed();
        this.pageCount = (int)Math.ceil((double)this.CONTENT_TABS.size() / 10.0);
    }

    public void renderTabs(GuiUtils gui) {
        this.searchBox.visible = this.hasSearchBar();
        this.renderTabsInGui(gui);
        CreativeModeTab tab = this.getTabAtPosition(gui.getMouseX(), gui.getMouseY());
        if (tab != null) {
            gui.renderTooltip(tab.getDisplayName(), gui.getMouseX(), gui.getMouseY());
        }
        if (selectedTab.showTitle()) {
            gui.drawString(selectedTab.getDisplayName(), this.parentScreen.getLeftPos() + 8, this.parentScreen.getTopPos() + 6, 0x404040, false);
        }
        if (this.pageCount > 1) {
            MutableComponent pageCounter = Component.literal((String)String.format("%d / %d", tabPage + 1, this.pageCount));
            gui.drawString((Component)pageCounter, this.parentScreen.getLeftPos() + this.parentScreen.imageLength / 2 - gui.getFont().width((FormattedText)pageCounter) / 2, this.parentScreen.getTopPos() - 34, -1, true);
        }
    }

    public boolean hasSearchBar() {
        return selectedTab == CreativeModeTabs.searchTab() || selectedTab == ALLOWED_TAB || selectedTab == TabManager.getTabFromKey((ResourceKey<CreativeModeTab>)CreativeModeTabs.HOTBAR);
    }

    public EditBox getSearchBox() {
        return this.searchBox;
    }

    public static CreativeModeTab getSelectedTab() {
        return selectedTab;
    }

    public static int getTabPage() {
        return tabPage;
    }

    public void init(Consumer<AbstractWidget> action) {
        if (this.pageCount > 1) {
            int leftPos = this.parentScreen.getLeftPos();
            int topPos = this.parentScreen.getTopPos();
            action.accept((AbstractWidget)Button.builder((Component)Component.literal((String)"<"), b -> this.setPage(false)).pos(leftPos - 22, topPos - 22).size(20, 20).build());
            action.accept((AbstractWidget)Button.builder((Component)Component.literal((String)">"), b -> this.setPage(true)).pos(leftPos + this.parentScreen.imageLength, topPos - 22).size(20, 20).build());
        }
        this.searchBox = new ListenerEditBox(this.parentScreen.getFont(), this.parentScreen.getLeftPos() + 99, this.parentScreen.getTopPos() - 10, 70, 12, (Component)Component.translatable((String)"itemGroup.search"), this.parentScreen.BLOCKS_MANAGER::searchBlocks, null);
        this.searchBox.setMaxLength(Short.MAX_VALUE);
        this.searchBox.setBordered(false);
        this.searchBox.setTextColor(0xFFFFFF);
        action.accept((AbstractWidget)this.searchBox);
    }

    public boolean mouseClicked(double x, double y) {
        CreativeModeTab tab = this.getTabAtPosition(x, y);
        if (tab != null) {
            return this.selectTab(tab);
        }
        return false;
    }

    public boolean selectTab(CreativeModeTab tab) {
        List<SavedBlock> list = BlocksManager.ALL_TAB_CONTENTS.get(TabManager.getKeyFromTab(tab));
        if (list != null) {
            boolean flag;
            CreativeModeTab old = selectedTab;
            selectedTab = tab;
            ScrollerManager<SavedBlock> manager = this.parentScreen.BLOCKS_MANAGER.scrollerManager;
            if (old != tab) {
                manager.setScrollOffset(0.0f);
            }
            manager.setMainList(list);
            manager.refreshList();
            this.searchBox.setValue("");
            this.searchBox.visible = flag = this.hasSearchBar();
            this.searchBox.setCanLoseFocus(!flag);
            this.searchBox.setFocused(flag);
            return true;
        }
        return false;
    }

    private void initTabs() {
        LocalPlayer player = (LocalPlayer)this.parentScreen.getPlayer();
        if (CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)player.connection.enabledFeatures(), (boolean)true, (HolderLookup.Provider)player.level().registryAccess())) {
            SessionSearchTrees sessionSearchTrees = player.connection.searchTrees();
            List list = List.copyOf(CreativeModeTabs.searchTab().getDisplayItems());
            sessionSearchTrees.updateCreativeTooltips((HolderLookup.Provider)player.level().registryAccess(), list);
            sessionSearchTrees.updateCreativeTags(list);
        }
    }

    private void setPage(boolean up) {
        tabPage = up ? Math.min(tabPage + 1, this.pageCount - 1) : Math.max(tabPage - 1, 0);
    }

    protected boolean isSelected(boolean special, int i) {
        return (special ? this.SPECIAL_TABS : this.CONTENT_TABS).get(i) == selectedTab;
    }

    protected void putAllowedTabIfNeed() {
        List<SavedBlock> blocks = BlocksManager.ALL_TAB_CONTENTS.get(TabManager.getKeyFromTab(ALLOWED_TAB));
        if (blocks != null) {
            if (!this.needAllowedTab) {
                this.SPECIAL_TABS.remove(ALLOWED_TAB);
            } else {
                List<SavedBlock> filteredBlocks = blocks.stream().filter(savedBlock -> {
                    BannedBlock reason = BannedBlock.isBannedBlock(savedBlock.getState(), this.parentScreen.player, BannedBlock.Source.SYSTEM);
                    return reason == null || reason.systemLock();
                }).toList();
                if (filteredBlocks.size() != BlocksManager.ALL_BLOCKS.size()) {
                    if (!this.SPECIAL_TABS.contains(ALLOWED_TAB)) {
                        this.SPECIAL_TABS.add(ALLOWED_TAB);
                    }
                } else {
                    this.SPECIAL_TABS.remove(ALLOWED_TAB);
                }
            }
        }
    }

    protected void renderTabsInGui(GuiUtils gui) {
        this.renderContentTabs(gui);
        this.renderSpecialTabs(gui);
    }

    protected void renderSpecialTabs(GuiUtils gui) {
        for (int i = 0; i < this.SPECIAL_TABS.size(); ++i) {
            int tabXSpecial = this.parentScreen.getLeftPos() + this.parentScreen.imageLength - 38 - i * 32;
            gui.blit(TABS_SPRITE, tabXSpecial, this.getTabY(-1), this.isSelected(true, i) ? 28.0f : 0.0f, 0.0f, 28, 32, 64, 88);
            this.renderItemInTab(gui, null, i, -1);
        }
    }

    protected void renderContentTabs(GuiUtils gui) {
        int count = 0;
        for (int i = tabPage * 10; i < tabPage * 10 + 10 && i < this.CONTENT_TABS.size(); ++i) {
            boolean isRight = count >= 5;
            int tabXSpecial = this.parentScreen.getLeftPos() + (isRight ? this.parentScreen.imageLength - 4 : -28);
            gui.blit(TABS_SPRITE, tabXSpecial, this.getTabY(count), isRight ? 32.0f : 0.0f, this.isSelected(false, i) ? 60.0f : 32.0f, 32, 28, 64, 88);
            this.renderItemInTab(gui, isRight, i, count);
            ++count;
        }
    }

    protected void renderItemInTab(GuiUtils gui, @Nullable Boolean isRight, int listIndex, int offsetIndex) {
        boolean isDown;
        boolean bl = isDown = isRight == null;
        float tabX = isDown ? (float)(this.parentScreen.getLeftPos() + this.parentScreen.imageLength - 37 - listIndex * 32 + 5) : (float)(this.parentScreen.getLeftPos() + (isRight != false ? this.parentScreen.imageLength + 2 : -19));
        int tabY = this.getTabY(offsetIndex) + (isDown ? 7 : 5);
        ItemStack itemstack = (isDown ? this.SPECIAL_TABS : this.CONTENT_TABS).get(listIndex).getIconItem();
        gui.renderItem(itemstack, tabX, tabY, 1.0f, 100.0f);
    }

    protected CreativeModeTab getTabAtPosition(double x, double y) {
        int i;
        int leftPos = this.parentScreen.getLeftPos();
        int imageWidth = this.parentScreen.imageLength;
        int tabYSpecial = this.getTabY(-1);
        for (i = 0; i < this.SPECIAL_TABS.size(); ++i) {
            int tabXSpecial = leftPos + imageWidth - 38 - i * 32;
            if (!(x > (double)tabXSpecial) || !(x < (double)(tabXSpecial + 28)) || !(y > (double)tabYSpecial) || !(y < (double)(tabYSpecial + 32))) continue;
            return this.SPECIAL_TABS.get(i);
        }
        for (i = 0; i < 10; ++i) {
            int tabX = leftPos;
            int tabY = this.getTabY(i);
            tabX = i < 5 ? (tabX -= 28) : (tabX += imageWidth - 4);
            if (!(x > (double)tabX) || !(x < (double)(tabX + 32)) || !(y > (double)tabY) || !(y < (double)(tabY + 28)) || 10 * tabPage + i >= this.CONTENT_TABS.size()) continue;
            return this.CONTENT_TABS.get(10 * tabPage + i);
        }
        return null;
    }

    public static CreativeModeTab getTabFromKey(ResourceKey<CreativeModeTab> name) {
        return (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.getOrThrow(name);
    }

    public static ResourceKey<CreativeModeTab> getKeyFromTab(CreativeModeTab tab) {
        if (tab == ALLOWED_TAB) {
            return BlocksManager.ALLOWED_TAB_KEY;
        }
        return (ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey((Object)tab).orElseThrow();
    }

    protected int getTabY(int i) {
        if (i < 0) {
            return this.parentScreen.getTopPos() + this.parentScreen.imageHeight - 4;
        }
        if (i > 4) {
            i -= 5;
        }
        return this.parentScreen.getTopPos() + 3 + i * 32;
    }
}

