/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.CollectionTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.CompoundTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive.NumericTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive.StringTagRenderer;
import net.blockomorph.utils.MorphUtils;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import org.jetbrains.annotations.Nullable;

public class TagTypes {
    private static final HashMap<TagType<?>, TagRendererFactory<?>> RENDERERS = new HashMap();
    private static final HashMap<TagType<?>, Supplier<?>> TAGS = new HashMap();

    public static <T extends Tag> void registerRenderer(TagType<T> type, TagRendererFactory<T> factory) {
        if (RENDERERS.containsKey(type)) {
            throw new IllegalArgumentException("Type " + type.getName() + " already registered!");
        }
        RENDERERS.put(type, factory);
    }

    public static <T extends Tag> void registerTagCreator(TagType<T> type, Supplier<T> creator) {
        if (TAGS.containsKey(type)) {
            throw new IllegalArgumentException("Type " + type.getName() + " already registered!");
        }
        TAGS.put(type, creator);
    }

    public static TagType<?>[] getRegisteredTags() {
        TagType[] array = new TagType[TAGS.size()];
        int i = 0;
        Iterator<TagType<?>> iterator = TAGS.keySet().iterator();
        while (iterator.hasNext()) {
            TagType<?> tagType;
            array[i] = tagType = iterator.next();
            ++i;
        }
        return array;
    }

    @Nullable
    public static <T extends Tag> TagRenderer<T> getRendererForTag(String name, T tag, TagRendererContext<T> ctx) {
        try {
            TagRendererFactory<?> renderSource = RENDERERS.get(tag.getType());
            if (renderSource != null) {
                return renderSource.create(name, tag, ctx);
            }
        }
        catch (ClassCastException e) {
            MorphUtils.LOGGER.error("Invalid tag registration for NBT Editor: ", (Throwable)e);
            return null;
        }
        return null;
    }

    public static <T extends Tag> Supplier<T> createDefaultTag(TagType<T> type) {
        try {
            return TAGS.get(type);
        }
        catch (Exception e) {
            MorphUtils.LOGGER.error("Invalid tag registration for NBT Editor: ", (Throwable)e);
            return null;
        }
    }

    static {
        TagTypes.registerRenderer(CompoundTag.TYPE, CompoundTagRenderer::new);
        TagTypes.registerRenderer(StringTag.TYPE, StringTagRenderer::new);
        TagTypes.registerRenderer(IntTag.TYPE, NumericTagRenderer.IntTagRenderer::new);
        TagTypes.registerRenderer(LongTag.TYPE, NumericTagRenderer.LongTagRenderer::new);
        TagTypes.registerRenderer(DoubleTag.TYPE, NumericTagRenderer.DoubleTagRenderer::new);
        TagTypes.registerRenderer(FloatTag.TYPE, NumericTagRenderer.FloatTagRenderer::new);
        TagTypes.registerRenderer(ShortTag.TYPE, NumericTagRenderer.ShortTagRenderer::new);
        TagTypes.registerRenderer(ByteTag.TYPE, NumericTagRenderer.ByteTagRenderer::new);
        TagTypes.registerRenderer(ListTag.TYPE, CollectionTagRenderer.ListTagRenderer::new);
        TagTypes.registerRenderer(IntArrayTag.TYPE, CollectionTagRenderer.IntArrayTagRenderer::new);
        TagTypes.registerRenderer(LongArrayTag.TYPE, CollectionTagRenderer.LongArrayTagRenderer::new);
        TagTypes.registerRenderer(ByteArrayTag.TYPE, CollectionTagRenderer.ByteArrayTagRenderer::new);
        TagTypes.registerTagCreator(StringTag.TYPE, () -> StringTag.valueOf((String)""));
        TagTypes.registerTagCreator(CompoundTag.TYPE, CompoundTag::new);
        TagTypes.registerTagCreator(ListTag.TYPE, ListTag::new);
        TagTypes.registerTagCreator(IntArrayTag.TYPE, () -> new IntArrayTag(new int[0]));
        TagTypes.registerTagCreator(LongArrayTag.TYPE, () -> new LongArrayTag(new long[0]));
        TagTypes.registerTagCreator(ByteArrayTag.TYPE, () -> new ByteArrayTag(new byte[0]));
        TagTypes.registerTagCreator(IntTag.TYPE, () -> IntTag.valueOf((int)0));
        TagTypes.registerTagCreator(LongTag.TYPE, () -> LongTag.valueOf((long)0L));
        TagTypes.registerTagCreator(DoubleTag.TYPE, () -> DoubleTag.valueOf((double)0.0));
        TagTypes.registerTagCreator(FloatTag.TYPE, () -> FloatTag.valueOf((float)0.0f));
        TagTypes.registerTagCreator(ShortTag.TYPE, () -> ShortTag.valueOf((short)0));
        TagTypes.registerTagCreator(ByteTag.TYPE, () -> ByteTag.valueOf((byte)0));
    }

    @FunctionalInterface
    public static interface TagRendererFactory<T extends Tag> {
        public TagRenderer<T> create(String var1, T var2, TagRendererContext<T> var3);
    }
}

