/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.propertiesWidget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.blockomorph.screens.morphConfig.propertiesWidget.PropertyRenderer;
import net.blockomorph.screens.morphConfig.propertiesWidget.renderers.BooleanPropertyRenderer;
import net.blockomorph.screens.morphConfig.propertiesWidget.renderers.EnumPropertyRenderer;
import net.blockomorph.screens.morphConfig.propertiesWidget.renderers.IntegerPropertyRenderer;
import net.blockomorph.screens.morphConfig.propertiesWidget.renderers.UnknownPropertyRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ScrollerManager;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStatePropsRenderer {
    private final HashMap<Class<?>, PropertyRenderer<?, ?>> RENDERERS = new HashMap();
    private final int x;
    private final int y;
    protected static final int PLATE_LENGTH = 67;
    protected static final int PLATE_HEIGHT = 19;
    private final Consumer<BlockState> newStateHandler;
    private final List<RenderableProperty<?, ?>> renderableProperties;
    private final ScrollerManager<RenderableProperty<?, ?>> scrollerManager;
    private final Supplier<BlockState> stateSource;
    private final int maxPlatesCount;
    private BlockState currentState;

    public BlockStatePropsRenderer(int x, int y, int maxPlatesCount, Supplier<BlockState> stateSource, Consumer<BlockState> newStateHandler) {
        this.x = x;
        this.y = y;
        this.maxPlatesCount = maxPlatesCount;
        this.stateSource = stateSource;
        this.newStateHandler = newStateHandler;
        this.renderableProperties = new ArrayList(maxPlatesCount);
        this.scrollerManager = new ScrollerManager(null, null, 0, 1, maxPlatesCount, this.renderableProperties, null);
        this.RENDERERS.put(BooleanProperty.class, new BooleanPropertyRenderer());
        this.RENDERERS.put(IntegerProperty.class, new IntegerPropertyRenderer());
        this.RENDERERS.put(EnumProperty.class, new EnumPropertyRenderer());
        this.RENDERERS.put(Property.class, new UnknownPropertyRenderer());
    }

    public void render(GuiUtils gui) {
        BlockState state = this.stateSource.get();
        if (!state.equals(this.currentState)) {
            this.setBlockState(state);
        }
        this.renderProperties(gui, false);
        this.renderProperties(gui, true);
        for (RenderableProperty<?, ?> renderableProperty : this.renderableProperties) {
            if (renderableProperty.renderTooltip(gui)) break;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int type) {
        if (type == 0) {
            this.RENDERERS.forEach((clazz, render) -> render.startClick());
            for (RenderableProperty<?, ?> instance : this.renderableProperties) {
                if (!instance.mouseClicked(mouseX, mouseY)) continue;
                this.RENDERERS.forEach((clazz, render) -> render.endClick());
                return true;
            }
            this.RENDERERS.forEach((clazz, render) -> render.endClick());
        }
        return false;
    }

    public boolean mouseScrolled(double x, double y, double yScrolled) {
        for (RenderableProperty<?, ?> instance : this.renderableProperties) {
            if (!instance.mouseScrolled(x, y, yScrolled)) continue;
            return true;
        }
        if (GuiUtils.isMouseOver(this.x, this.y, this.x + 67, this.y + 19 * this.maxPlatesCount, x, y)) {
            return this.scrollerManager.mouseScrolled(yScrolled);
        }
        return false;
    }

    private void renderProperties(GuiUtils gui, boolean mainPhase) {
        for (int i = 0; i < this.renderableProperties.size(); ++i) {
            int yStart = i * 19;
            this.renderableProperties.get(i).render(gui, mainPhase, yStart);
        }
    }

    private void setBlockState(BlockState state) {
        if (this.currentState == null || !state.is(this.currentState.getBlock())) {
            this.scrollerManager.setScrollOffset(0.0f);
        }
        this.currentState = state;
        ArrayList<RenderableProperty> properties = new ArrayList<RenderableProperty>();
        for (Property property : this.currentState.getProperties()) {
            properties.add(new RenderableProperty(this, property));
        }
        this.scrollerManager.setMainList(properties);
        this.scrollerManager.refreshList();
    }

    private static class RenderableProperty<VALUE extends Comparable<VALUE>, T extends Property<VALUE>> {
        private final Rect2i box = new Rect2i(0, 0, 0, 0);
        private final PropertyRenderer<VALUE, T> renderer;
        private final T property;
        private final VALUE value;
        final /* synthetic */ BlockStatePropsRenderer this$0;

        private RenderableProperty(T property) {
            PropertyRenderer<?, ?> renderer;
            this.this$0 = var1_1;
            this.property = property;
            this.value = var1_1.currentState.getValue(property);
            Class<?> clazz = property.getClass();
            while (true) {
                if ((renderer = var1_1.RENDERERS.get(clazz)) != null) break;
                clazz = clazz.getSuperclass();
            }
            this.renderer = renderer;
        }

        public void render(GuiUtils gui, boolean mainPhase, int yOffset) {
            this.box.setPosition(this.this$0.x, this.this$0.y + yOffset);
            this.box.setWidth(67);
            this.box.setHeight(19);
            if (mainPhase) {
                this.renderer.render(gui, this.property, this.value, this.box);
            } else {
                this.renderer.renderBackground(gui, this.property, this.value, this.box);
                this.renderer.renderPropertyName(gui, this.property, this.box);
            }
        }

        public boolean renderTooltip(GuiUtils gui) {
            return this.renderer.renderTooltip(gui, this.property, this.value, this.box);
        }

        public boolean mouseClicked(double mouseX, double mouseY) {
            return this.renderer.mouseClicked(this.this$0.newStateHandler, this.this$0.currentState, this.property, this.value, mouseX, mouseY, this.box);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double yOffsetWheel) {
            return this.renderer.mouseScrolled(this.this$0.newStateHandler, this.this$0.currentState, this.property, this.value, mouseX, mouseY, yOffsetWheel, this.box);
        }
    }
}

