/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.blockomorph.screens.overlay.BlockHeartOverlay;
import net.blockomorph.screens.overlay.Overlay;
import net.blockomorph.screens.overlay.PlayerCrackOverlay;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GuiUtils {
    private static final Function<ResourceLocation, RenderType> GUI_TEXTURE_WITH_ALPHA = Util.memoize(texture -> RenderType.create((String)"gui_texture_with_alpha", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setShaderState(RenderType.POSITION_TEX_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).createCompositeState(false)));
    private static final HashMap<Block, Boolean> BE_WITH_RENDERERS = new HashMap();
    public static final BlockPos AIR = new BlockPos(0, 500, 0);
    public static final Minecraft MC = Minecraft.getInstance();
    public static final List<Overlay> OVERLAYS = new ArrayList<Overlay>();
    private static final Vector3f DIFFUSE_LIGHT_START;
    private static final Vector3f DIFFUSE_LIGHT_END;
    public static final MultiBufferSource.BufferSource bufferSource;
    public static final BlockRenderDispatcher blockRenderer;
    public static final BlockEntityRenderDispatcher blockEntityRenderer;
    private GuiGraphics GUI;
    private int mouseX;
    private int mouseY;
    private float tick;
    private Font font;

    public static ResourceLocation res(String path) {
        return MorphUtils.res(path);
    }

    public static ResourceLocation vanillaRes(String path) {
        return MorphUtils.vanillaRes(path);
    }

    public void setGuiGraphics(GuiGraphics gui, Font font, int mouseX, int mouseY, float tick) {
        this.GUI = gui;
        this.font = font;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.tick = tick;
    }

    public GuiGraphics getGuiGraphics() {
        return this.GUI;
    }

    public Font getFont() {
        return this.font;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public float getTick() {
        return this.tick;
    }

    public void blit(ResourceLocation texture, int x, int y, float u, float v, int uvMaxX, int uvMaxY, int maxX, int maxY) {
        this.drawPreparedTexture(texture, x, x + uvMaxX, y, y + uvMaxY, u / (float)maxX, (u + (float)uvMaxX) / (float)maxX, v / (float)maxY, (v + (float)uvMaxY) / (float)maxY);
    }

    public void blitMonoImage(ResourceLocation resourceLocation, int x, int y, int maxSizeX, int maxSizeY) {
        this.blit(resourceLocation, x, y, 0.0f, 0.0f, maxSizeX, maxSizeY, maxSizeX, maxSizeY);
    }

    private void drawPreparedTexture(ResourceLocation texture, int x, int xEnd, int y, int yEnd, float u, float uEnd, float v, float vEnd) {
        Matrix4f matrix4f = this.GUI.pose().last().pose();
        VertexConsumer vertexconsumer = bufferSource.getBuffer(GUI_TEXTURE_WITH_ALPHA.apply(texture));
        vertexconsumer.addVertex(matrix4f, (float)x, (float)y, 0.0f).setUv(u, v);
        vertexconsumer.addVertex(matrix4f, (float)x, (float)yEnd, 0.0f).setUv(u, vEnd);
        vertexconsumer.addVertex(matrix4f, (float)xEnd, (float)yEnd, 0.0f).setUv(uEnd, vEnd);
        vertexconsumer.addVertex(matrix4f, (float)xEnd, (float)y, 0.0f).setUv(uEnd, v);
        this.GUI.flush();
    }

    public void renderTooltip(Component text, int mouseX, int mouseY) {
        this.renderTooltip(List.of(text), mouseX, mouseY);
    }

    public void renderTooltip(List<Component> texts, int mouseX, int mouseY) {
        this.GUI.renderComponentTooltip(this.font, texts, mouseX, mouseY);
    }

    public void renderSprite(ResourceLocation resourceLocation, int x, int y, int maxSizeX, int maxSizeY) {
        this.GUI.blitSprite(resourceLocation, x, y, maxSizeX, maxSizeY);
    }

    public void renderFromSpriteClass(TextureAtlasSprite sprite, int x, int y, int maxSizeX, int maxSizeY, int color) {
        this.GUI.blit(x, y, 0, maxSizeX, maxSizeY, sprite, (float)FastColor.ARGB32.red((int)color) / 255.0f, (float)FastColor.ARGB32.green((int)color) / 255.0f, (float)FastColor.ARGB32.blue((int)color) / 255.0f, (float)FastColor.ARGB32.alpha((int)color) / 255.0f);
    }

    public void drawString(Component text, int x, int y, int color, boolean useShadow) {
        this.GUI.drawString(this.font, text, x, y, color, useShadow);
    }

    public void drawCenteredString(Component text, int xCenter, int y, int color, boolean useShadow) {
        int x = xCenter - this.font.width(text.getString()) / 2;
        this.drawString(text, x, y, color, useShadow);
    }

    public void drawCenteredStringWithAdditional(Component text, int xCenter, int y, int color, boolean useShadow, BiConsumer<Integer, Integer> additional) {
        int length = this.font.width(text.getString());
        int x = xCenter - length / 2;
        additional.accept(x, length);
        this.drawString(text, x, y, color, useShadow);
    }

    public void fill(int x, int y, int endX, int endY, int color) {
        this.GUI.fill(x, y, endX, endY, color);
    }

    public void blurScreen(int width, int height, int alpha) {
        this.fill(0, 0, width, height, FastColor.ARGB32.color((int)alpha, (int)77, (int)77, (int)77));
    }

    public void enableScrissors(int x, int y, int endX, int endY) {
        this.GUI.enableScissor(x, y, endX, endY);
    }

    public void disableScrissors() {
        this.GUI.disableScissor();
    }

    public void renderItem(ItemStack item, float x, float y, float scale, float zDepth) {
        if (scale == 1.0f) {
            scale = 16.0f;
        }
        PoseStack pose = this.GUI.pose();
        pose.pushPose();
        pose.translate(x + 8.0f, y + 8.0f, 150.0f + zDepth);
        pose.scale(scale, -scale, scale);
        this.doMainRenderingItem(pose, item);
        pose.popPose();
    }

    public void renderInDepthIfNeededAfterBlockRendering(Runnable rendering) {
        PoseStack stack = this.GUI.pose();
        stack.pushPose();
        stack.translate(0.0f, 0.0f, 300.0f);
        rendering.run();
        stack.popPose();
    }

    public static void renderOverlay(GuiGraphics gui, float delta) {
        GuiUtils guiUtils = new GuiUtils();
        guiUtils.setGuiGraphics(gui, GuiUtils.MC.font, -100, -100, delta);
        Window window = Minecraft.getInstance().getWindow();
        if (GuiUtils.MC.level != null) {
            OVERLAYS.forEach(overlay -> overlay.render(guiUtils, window.getGuiScaledWidth(), window.getGuiScaledHeight()));
        }
    }

    private void doMainRenderingItem(PoseStack stack, ItemStack item) {
        boolean bl;
        BakedModel bakedModel = MC.getItemRenderer().getModel(item, (Level)GuiUtils.MC.level, (LivingEntity)GuiUtils.MC.player, 0);
        boolean bl2 = bl = !bakedModel.usesBlockLight();
        if (bl) {
            Lighting.setupForFlatItems();
        }
        MC.getItemRenderer().render(item, ItemDisplayContext.GUI, false, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        this.GUI.flush();
        if (bl) {
            Lighting.setupFor3DItems();
        }
    }

    public void renderBlockInGui(BlockState blockState, @Nullable BlockEntity blockEntity, float x, float y, float scale) {
        PoseStack stack = this.GUI.pose();
        stack.pushPose();
        stack.translate(x, y, 100.0f);
        stack.scale(scale, -scale, scale);
        stack.mulPose(Axis.XP.rotationDegrees(30.0f));
        stack.mulPose(Axis.YP.rotationDegrees(-135.0f));
        this.renderBlock(stack, blockState, blockEntity != null ? blockEntity.getBlockPos() : AIR);
        RenderSystem.setShaderLights((Vector3f)DIFFUSE_LIGHT_START, (Vector3f)DIFFUSE_LIGHT_END);
        this.renderBlockEntity(stack, blockEntity);
        stack.popPose();
    }

    private void renderBlock(PoseStack stack, BlockState blockState, BlockPos pos) {
        RandomSource random = RandomSource.create((long)blockState.getSeed(pos));
        if (blockState.getRenderShape() == RenderShape.MODEL) {
            ClientLevelAccessor acc = ClientLevelAccessor.of((Level)GuiUtils.MC.level);
            acc.setSpecialRenderingMode(true);
            BakedModel model = blockRenderer.getBlockModel(blockState);
            ModelData modeldata = model.getModelData((BlockAndTintGetter)GuiUtils.MC.level, pos, blockState, ModelData.EMPTY);
            for (RenderType renderType : model.getRenderTypes(blockState, random, modeldata)) {
                VertexConsumer vertex = bufferSource.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType));
                blockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)GuiUtils.MC.level, model, blockState, pos, stack, vertex, false, random, blockState.getSeed(pos), OverlayTexture.NO_OVERLAY, modeldata, renderType);
            }
            acc.setSpecialRenderingMode(false);
        }
    }

    private Boolean skipCheckOrContainsRenderer(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            return BE_WITH_RENDERERS.computeIfAbsent(block, b -> {
                BlockEntity ent = entityBlock.newBlockEntity(AIR, state);
                if (ent == null) {
                    return false;
                }
                return blockEntityRenderer.getRenderer(ent) != null;
            });
        }
        return null;
    }

    public void renderAdditionalOnBlock(BlockState blockState, float x, float y, float scale) {
        Boolean result = this.skipCheckOrContainsRenderer(blockState);
        if (!(blockState.getRenderShape() != RenderShape.INVISIBLE || result != null && result.booleanValue())) {
            Item item = null;
            if (blockState.getBlock() instanceof LiquidBlock) {
                item = blockState.getFluidState().getType().getBucket();
            } else if (blockState.getBlock().asItem() != Items.AIR) {
                item = blockState.getBlock().asItem();
            }
            if (item != null) {
                ItemStack itemStack = new ItemStack((ItemLike)item);
                HashMap<String, String> map = new HashMap<String, String>();
                for (Property property : blockState.getProperties()) {
                    map.put(property.getName(), blockState.getValue(property).toString());
                }
                itemStack.set(DataComponents.BLOCK_STATE, (Object)new BlockItemStateProperties(map));
                this.renderItem(itemStack, x, y, scale, 100.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BlockEntity> void renderBlockEntity(PoseStack stack, T blockEntity) {
        BlockEntityRenderer renderer;
        if (blockEntity != null && (renderer = blockEntityRenderer.getRenderer(blockEntity)) != null) {
            ClientLevelAccessor acc = ClientLevelAccessor.of((Level)GuiUtils.MC.level);
            try {
                acc.setSpecialRenderingMode(true);
                renderer.render(blockEntity, this.tick, stack, (MultiBufferSource)bufferSource, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
            }
            catch (Exception exception) {
            }
            finally {
                acc.setSpecialRenderingMode(false);
            }
        }
    }

    public static boolean isMouseOver(int x, int y, int endX, int endY, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)endX && mouseY >= (double)y && mouseY < (double)endY;
    }

    public static boolean isInBounds(Rect2i box, double mouseX, double mouseY) {
        return GuiUtils.isMouseOver(box.getX(), box.getY(), box.getX() + box.getWidth(), box.getY() + box.getHeight(), mouseX, mouseY);
    }

    public static void playClickSound() {
        MC.getSoundManager().play(GuiUtils.getClickSound());
    }

    public static SoundInstance getClickSound() {
        return SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f);
    }

    public static void pushHotbarMessage(Component text) {
        GuiUtils.MC.gui.setOverlayMessage(text, false);
        MC.getNarrator().sayNow(text);
    }

    static {
        bufferSource = MC.renderBuffers().bufferSource();
        blockRenderer = MC.getBlockRenderer();
        blockEntityRenderer = MC.getBlockEntityRenderDispatcher();
        Matrix4f matrix4f = new Matrix4f().scaling(1.0f, -1.0f, 1.0f).rotateYXZ(1.0821041f, 3.2375858f, 0.0f).rotateYXZ(-2.41661f, 2.3561945f, 0.0f);
        DIFFUSE_LIGHT_START = matrix4f.transformDirection((Vector3fc)new Vector3f(0.2f, 1.0f, -0.7f).normalize(), new Vector3f());
        DIFFUSE_LIGHT_END = matrix4f.transformDirection((Vector3fc)new Vector3f(-0.2f, 1.0f, 0.7f).normalize(), new Vector3f());
        OVERLAYS.add(new PlayerCrackOverlay());
        OVERLAYS.add(new BlockHeartOverlay());
    }
}

